/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.util;

import com.google.code.or.common.glossary.UnsignedLong;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.net.Packet;
import com.google.code.or.net.Transport;
import com.google.code.or.net.TransportException;
import com.google.code.or.net.impl.packet.EOFPacket;
import com.google.code.or.net.impl.packet.ErrorPacket;
import com.google.code.or.net.impl.packet.ResultSetFieldPacket;
import com.google.code.or.net.impl.packet.ResultSetHeaderPacket;
import com.google.code.or.net.impl.packet.ResultSetRowPacket;
import com.google.code.or.net.impl.packet.command.ComQuery;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryUtil.class);

    public static List<ResultSetRowPacket> query(String sql, Transport transport) throws IOException {
        LinkedList<ResultSetRowPacket> resultSet = new LinkedList<ResultSetRowPacket>();
        ComQuery command = new ComQuery();
        command.setSql(StringColumn.valueOf(sql.getBytes()));
        transport.getOutputStream().writePacket(command);
        transport.getOutputStream().flush();
        Packet packet = transport.getInputStream().readPacket();
        if (packet.getPacketBody()[0] == -1) {
            ErrorPacket error = ErrorPacket.valueOf(packet);
            LOGGER.info("{}", (Object)error);
            throw new TransportException(error);
        }
        ResultSetHeaderPacket header = ResultSetHeaderPacket.valueOf(packet);
        LOGGER.info("{}", (Object)header);
        if (header.getFieldCount() == UnsignedLong.valueOf(0L)) {
            return resultSet;
        }
        while (true) {
            if ((packet = transport.getInputStream().readPacket()).getPacketBody()[0] == -2) break;
            ResultSetFieldPacket field = ResultSetFieldPacket.valueOf(packet);
            LOGGER.info("{}", (Object)field);
        }
        EOFPacket eof = EOFPacket.valueOf(packet);
        LOGGER.info("{}", (Object)eof);
        while (true) {
            if ((packet = transport.getInputStream().readPacket()).getPacketBody()[0] == -2) break;
            ResultSetRowPacket row = ResultSetRowPacket.valueOf(packet);
            resultSet.add(row);
            LOGGER.info("{}", (Object)row);
        }
        eof = EOFPacket.valueOf(packet);
        LOGGER.info("{}", (Object)eof);
        return resultSet;
    }
}

