/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.UnsignedLong;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class OKPacket
extends AbstractPacket {
    private static final long serialVersionUID = 3674181092305117701L;
    public static final byte PACKET_MARKER = 0;
    private int packetMarker;
    private UnsignedLong affectedRows;
    private UnsignedLong insertId;
    private int serverStatus;
    private int warningCount;
    private StringColumn message;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("packetMarker", this.packetMarker).append("affectedRows", (Object)this.affectedRows).append("insertId", (Object)this.insertId).append("serverStatus", this.serverStatus).append("warningCount", this.warningCount).append("message", (Object)this.message).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(64);
        s.writeInt(this.packetMarker, 1);
        s.writeUnsignedLong(this.affectedRows);
        s.writeUnsignedLong(this.insertId);
        s.writeInt(this.serverStatus, 2);
        s.writeInt(this.warningCount, 2);
        if (this.message != null) {
            s.writeFixedLengthString(this.message);
        }
        return s.toByteArray();
    }

    public int getPacketMarker() {
        return this.packetMarker;
    }

    public void setPacketMarker(int packetMarker) {
        this.packetMarker = packetMarker;
    }

    public UnsignedLong getAffectedRows() {
        return this.affectedRows;
    }

    public void setAffectedRows(UnsignedLong affectedRows) {
        this.affectedRows = affectedRows;
    }

    public UnsignedLong getInsertId() {
        return this.insertId;
    }

    public void setInsertId(UnsignedLong insertId) {
        this.insertId = insertId;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(int warningCount) {
        this.warningCount = warningCount;
    }

    public StringColumn getMessage() {
        return this.message;
    }

    public void setMessage(StringColumn message) {
        this.message = message;
    }

    public static OKPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        OKPacket r = new OKPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.packetMarker = d.readInt(1);
        r.affectedRows = d.readUnsignedLong();
        r.insertId = d.readUnsignedLong();
        r.serverStatus = d.readInt(2);
        r.warningCount = d.readInt(2);
        if (d.available() > 0) {
            r.message = d.readFixedLengthString(d.available());
        }
        return r;
    }
}

