/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetRowPacket
extends AbstractPacket {
    private static final long serialVersionUID = 698187140476020984L;
    private List<StringColumn> columns;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("columns", this.columns).toString();
    }

    @Override
    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(1024);
        for (StringColumn column : this.columns) {
            s.writeLengthCodedString(column);
        }
        return s.toByteArray();
    }

    public List<StringColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<StringColumn> columns) {
        this.columns = columns;
    }

    public static ResultSetRowPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        ResultSetRowPacket r = new ResultSetRowPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.setColumns(new LinkedList<StringColumn>());
        while (d.available() > 0) {
            r.getColumns().add(d.readLengthCodedString());
        }
        return r;
    }
}

