/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.http;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.http.impl.HttpProxy;
import com.flipkart.phantom.http.impl.HttpRequestWrapper;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.ServerRequestInterceptor;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import rx.Observable;

public abstract class RoutingHttpChannelHandler
extends SimpleChannelUpstreamHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingHttpChannelHandler.class);
    private static final String DEFAULT_SERVICE_NAME = "Http Proxy";
    public static final String ALL_ROUTES = "";
    public static final Set<String> REMOVE_HEADERS = new HashSet<String>();
    private static final String HTTP_HANDLER = "HTTP_HANDLER";
    private static final TraceFilter NO_TRACING;
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static String hostName;
    private String serviceName = "Http Proxy";
    private int hostPort;
    private ChannelGroup defaultChannelGroup;
    private ExecutorRepository<HttpRequestWrapper, HttpResponse, HttpProxy> repository;
    private Map<String, String> proxyMap = new HashMap<String, String>();
    private String defaultProxy;
    private ServiceProxyEventProducer eventProducer;
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.defaultProxy, (String)"The 'defaultProxy' may not be null");
        this.proxyMap.put(ALL_ROUTES, this.defaultProxy);
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelBound(ctx, event);
        if (InetSocketAddress.class.isAssignableFrom(event.getValue().getClass())) {
            this.hostPort = ((InetSocketAddress)event.getValue()).getPort();
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Observable observableResponse;
        long receiveTime = System.currentTimeMillis();
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http Request is: " + request.getMethod() + " " + request.getUri());
            LOGGER.debug("Http Headers : " + request.getHeaders().toString());
        }
        this.processRequestHeaders(request);
        ChannelBuffer inputBuffer = request.getContent();
        byte[] requestData = new byte[inputBuffer.readableBytes()];
        inputBuffer.readBytes(requestData, 0, requestData.length);
        HttpRequestWrapper executorHttpRequest = new HttpRequestWrapper();
        executorHttpRequest.setData(requestData);
        executorHttpRequest.setMethod(request.getMethod().toString());
        executorHttpRequest.setUri(request.getUri());
        executorHttpRequest.setHeaders(request.getHeaders());
        executorHttpRequest.setProtocol(request.getProtocolVersion().getProtocolName());
        executorHttpRequest.setMajorVersion(request.getProtocolVersion().getMajorVersion());
        executorHttpRequest.setMinorVersion(request.getProtocolVersion().getMinorVersion());
        executorHttpRequest.setServiceName(Optional.of((Object)this.serviceName));
        ServerRequestInterceptor<HttpRequestWrapper, HttpResponse> serverRequestInterceptor = this.initializeServerTracing(executorHttpRequest);
        String proxy = this.proxyMap.get(this.getRoutingKey(request));
        if (proxy == null) {
            proxy = this.proxyMap.get(ALL_ROUTES);
            LOGGER.info("Routing key for : " + request.getUri() + " returned null. Using default proxy instead.");
        }
        Executor executor = this.repository.getExecutor(proxy, proxy, (RequestWrapper)executorHttpRequest);
        try {
            observableResponse = executor.observe();
        }
        catch (Exception e) {
            RuntimeException runtimeException = new RuntimeException("Error in executing HTTP request:" + proxy + " URI:" + request.getUri(), e);
            this.informReqTracer(receiveTime, request, serverRequestInterceptor, (Executor<HttpRequestWrapper, HttpResponse>)executor, (Optional<RuntimeException>)Optional.of((Object)runtimeException), null);
            throw runtimeException;
        }
        String finalProxy = proxy;
        observableResponse.subscribe(response -> {
            try {
                this.informReqTracer(receiveTime, request, serverRequestInterceptor, (Executor<HttpRequestWrapper, HttpResponse>)executor, (Optional<RuntimeException>)Optional.absent(), (HttpResponse)response);
                this.writeCommandExecutionResponse(ctx, (ChannelEvent)messageEvent, request, (HttpResponse)response);
            }
            catch (Exception e) {
                LOGGER.error("Error while writing response", (Object)e.getMessage());
                throw new RuntimeException("Error in executing HTTP request:" + finalProxy + " URI:" + request.getUri(), e);
            }
        }, exception -> {
            RuntimeException runtimeException = new RuntimeException("Error in executing HTTP request:" + finalProxy + " URI:" + request.getUri(), (Throwable)exception);
            this.informReqTracer(receiveTime, request, serverRequestInterceptor, (Executor<HttpRequestWrapper, HttpResponse>)executor, (Optional<RuntimeException>)Optional.of((Object)runtimeException), null);
            messageEvent.getChannel().close();
        });
    }

    private void informReqTracer(long receiveTime, HttpRequest request, ServerRequestInterceptor<HttpRequestWrapper, HttpResponse> serverRequestInterceptor, Executor<HttpRequestWrapper, HttpResponse> executor, Optional<RuntimeException> transportError, HttpResponse response) {
        serverRequestInterceptor.process((Object)response, transportError);
        if (this.eventProducer != null) {
            ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(request.getUri(), HTTP_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData(executor).withEventSource(executor.getClass().getName());
            eventBuilder.withRequestReceiveTime(receiveTime);
            this.eventProducer.publishEvent(eventBuilder.build());
        } else {
            LOGGER.debug("eventProducer not set, not publishing event");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.error("Exception thrown on Channel. Disconnect initiated : " + event.getCause(), event.getCause());
        event.getChannel().close();
    }

    protected abstract String getRoutingKey(HttpRequest var1);

    protected void processRequestHeaders(HttpRequest request) {
        for (String header : REMOVE_HEADERS) {
            request.removeHeader(header);
        }
    }

    private ServerRequestInterceptor<HttpRequestWrapper, HttpResponse> initializeServerTracing(HttpRequestWrapper executorRequest) {
        ServerRequestInterceptor serverRequestInterceptor = new ServerRequestInterceptor();
        List<TraceFilter> traceFilters = Arrays.asList(this.traceFilter);
        ServerTracer serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, traceFilters);
        serverRequestInterceptor.setEndPointSubmitter(Brave.getEndPointSubmitter());
        serverRequestInterceptor.setServerTracer(serverTracer);
        serverRequestInterceptor.setServiceHost(hostName);
        serverRequestInterceptor.setServicePort(this.hostPort);
        serverRequestInterceptor.setServiceName(this.serviceName);
        serverRequestInterceptor.process((RequestWrapper)executorRequest);
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        RequestContext serverRequestContext = new RequestContext();
        serverRequestContext.setCurrentServerSpan(serverSpan);
        executorRequest.setRequestContext(Optional.of((Object)serverRequestContext));
        return serverRequestInterceptor;
    }

    private void writeCommandExecutionResponse(ChannelHandlerContext ctx, ChannelEvent event, HttpRequest request, HttpResponse response) throws Exception {
        if (response == null || response.getEntity() == null) {
            event.getChannel().write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT)).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.getStatusLine().getStatusCode()));
        for (Header header : response.getAllHeaders()) {
            if (REMOVE_HEADERS.contains(header.getName())) continue;
            httpResponse.setHeader(header.getName(), (Object)header.getValue());
        }
        HttpEntity responseEntity = response.getEntity();
        byte[] responseData = EntityUtils.toByteArray((HttpEntity)responseEntity);
        httpResponse.setHeader("Content-Length", (Object)responseData.length);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http Response status : " + response.getStatusLine().toString());
            LOGGER.debug("Http Response : " + new String(responseData));
        }
        httpResponse.setContent(ChannelBuffers.copiedBuffer((byte[])responseData));
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
        ChannelFuture channelFuture = event.getChannel().write((Object)httpResponse);
        if (!keepAlive) {
            channelFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public ExecutorRepository<HttpRequestWrapper, HttpResponse, HttpProxy> getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository<HttpRequestWrapper, HttpResponse, HttpProxy> repository) {
        this.repository = repository;
    }

    public Map<String, String> getProxyMap() {
        return this.proxyMap;
    }

    public void setProxyMap(Map<String, String> proxyMap) {
        this.proxyMap = proxyMap;
    }

    public String getDefaultProxy() {
        return this.defaultProxy;
    }

    public void setDefaultProxy(String defaultProxy) {
        this.defaultProxy = defaultProxy;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void setTraceFilter(TraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    static {
        REMOVE_HEADERS.add("Transfer-Encoding");
        REMOVE_HEADERS.add("Connection");
        REMOVE_HEADERS.add("Host");
        REMOVE_HEADERS.add("Proxy-Authenticate");
        REMOVE_HEADERS.add("TE");
        REMOVE_HEADERS.add("Trailers");
        REMOVE_HEADERS.add("Upgrade");
        NO_TRACING = new FixedSampleRateTraceFilter(-1);
        hostName = DEFAULT_HOST;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve local host name. Will use default host name : localhost");
        }
    }
}

