/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.thrift;

import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.channel.thrift.ThriftNettyChannelBuffer;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.flipkart.phantom.thrift.impl.ThriftProxyExecutor;
import com.flipkart.phantom.thrift.impl.ThriftRequestWrapper;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final int DEFAULT_RESPONSE_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftChannelHandler.class);
    private ExecutorRepository repository;
    private String thriftProxy;
    private int responseSize = 4096;
    private TProtocolFactory protocolFactory = new TBinaryProtocol.Factory();
    private ServiceProxyEventProducer eventProducer;
    private static final String THRIFT_HANDLER = "THRIFT_HANDLER";

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        block4: {
            Class<?> clazz;
            if (!MessageEvent.class.isAssignableFrom(event.getClass())) break block4;
            ChannelBuffer input = (ChannelBuffer)((MessageEvent)event).getMessage();
            ChannelBuffer output = ChannelBuffers.dynamicBuffer((int)this.responseSize);
            ThriftNettyChannelBuffer clientTransport = new ThriftNettyChannelBuffer(input, output);
            ThriftNettyChannelBuffer ttransport = new ThriftNettyChannelBuffer(input, null);
            TProtocol iprot = this.protocolFactory.getProtocol((TTransport)ttransport);
            input.markReaderIndex();
            TMessage message = iprot.readMessageBegin();
            input.resetReaderIndex();
            ThriftRequestWrapper thriftRequestWrapper = new ThriftRequestWrapper();
            thriftRequestWrapper.setClientSocket((TTransport)clientTransport);
            Executor executor = this.repository.getExecutor(message.name, this.thriftProxy, (RequestWrapper)thriftRequestWrapper);
            try {
                executor.execute();
                clazz = executor == null ? ((Object)((Object)this)).getClass() : Class.forName(((ThriftProxyExecutor)executor).getThriftProxy().getThriftServiceClass());
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Error in executing Thrift request: " + this.thriftProxy + ":" + message.name, e);
                }
                catch (Throwable throwable) {
                    Class<?> eventSource = executor == null ? ((Object)((Object)this)).getClass() : Class.forName(((ThriftProxyExecutor)executor).getThriftProxy().getThriftServiceClass());
                    String commandName = this.thriftProxy + ":" + message.name;
                    this.eventProducer.publishEvent(executor, commandName, eventSource, THRIFT_HANDLER);
                    throw throwable;
                }
            }
            Class<?> eventSource = clazz;
            String commandName = this.thriftProxy + ":" + message.name;
            this.eventProducer.publishEvent(executor, commandName, eventSource, THRIFT_HANDLER);
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)event.getFuture(), (Object)clientTransport.getOutputBuffer());
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
        super.exceptionCaught(ctx, event);
    }

    public ExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository repository) {
        this.repository = repository;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public String getThriftProxy() {
        return this.thriftProxy;
    }

    public void setThriftProxy(String thriftProxy) {
        this.thriftProxy = thriftProxy;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

