/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.sp.dashboard.impl.spring.web;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.FixedDelayPollingScheduler;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.config.sources.URLConfigurationSource;
import com.netflix.turbine.init.TurbineInit;
import java.io.File;
import java.net.URL;
import org.apache.commons.configuration.AbstractConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class TurbineInitializer
implements InitializingBean {
    private static final String FILE_PREFIX = "file:";
    private static final Logger LOGGER = LoggerFactory.getLogger(TurbineInitializer.class);

    public void afterPropertiesSet() throws Exception {
        LOGGER.info("Initializing turbine");
        try {
            File turbineConfig = FileLocator.findUniqueFile((String)"dashboard-config.properties");
            LOGGER.debug("Found dashboard config file: " + turbineConfig.getAbsolutePath());
            URLConfigurationSource source = new URLConfigurationSource(new URL[]{new URL(FILE_PREFIX + turbineConfig.getAbsolutePath())});
            DynamicConfiguration configuration = new DynamicConfiguration((PolledConfigurationSource)source, (AbstractPollingScheduler)new FixedDelayPollingScheduler());
            ConfigurationManager.install((AbstractConfiguration)configuration);
            TurbineInit.init();
            LOGGER.debug("Successfully inited Turbine");
        }
        catch (Exception e) {
            LOGGER.error("Error configuring and initing turbine", (Throwable)e);
        }
    }
}

