/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioClientSocketChannel;
import com.flipkart.phantom.netty.uds.OioWorker;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;

class OioClientSocketPipelineSink
extends AbstractChannelSink {
    private final Executor workerExecutor;

    OioClientSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        block11: {
            ChannelFuture future;
            OioClientSocketChannel channel;
            block10: {
                channel = (OioClientSocketChannel)e.getChannel();
                future = e.getFuture();
                if (!(e instanceof ChannelStateEvent)) break block10;
                ChannelStateEvent stateEvent = (ChannelStateEvent)e;
                ChannelState state = stateEvent.getState();
                Object value = stateEvent.getValue();
                switch (state) {
                    case OPEN: {
                        if (Boolean.FALSE.equals(value)) {
                            OioWorker.close(channel, future);
                            break;
                        }
                        break block11;
                    }
                    case BOUND: {
                        if (value != null) {
                            this.bind(channel, future, (SocketAddress)value);
                            break;
                        }
                        OioWorker.close(channel, future);
                        break;
                    }
                    case CONNECTED: {
                        if (value != null) {
                            this.connect(channel, future, (SocketAddress)value);
                            break;
                        }
                        OioWorker.close(channel, future);
                        break;
                    }
                    case INTEREST_OPS: {
                        OioWorker.setInterestOps(channel, future, (Integer)value);
                    }
                }
                break block11;
            }
            if (e instanceof MessageEvent) {
                OioWorker.write(channel, future, ((MessageEvent)e).getMessage());
            }
        }
    }

    private void bind(OioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            channel.socket.bind(localAddress);
            future.setSuccess();
            Channels.fireChannelBound((Channel)channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }

    private void connect(OioClientSocketChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        try {
            try {
                channel.socket.connect(remoteAddress, channel.getConfig().getConnectTimeoutMillis());
                connected = true;
                channel.in = new PushbackInputStream(channel.socket.getInputStream(), 1);
                channel.out = channel.socket.getOutputStream();
                future.setSuccess();
                if (!bound) {
                    Channels.fireChannelBound((Channel)channel, (SocketAddress)channel.getLocalAddress());
                }
                Channels.fireChannelConnected((Channel)channel, (SocketAddress)channel.getRemoteAddress());
                DeadLockProofWorker.start((Executor)this.workerExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)new OioWorker(channel), "Old I/O client worker (" + (Object)((Object)channel) + ')'));
                workerStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
                if (connected && !workerStarted) {
                    OioWorker.close(channel, future);
                }
            }
        }
        finally {
            if (connected && !workerStarted) {
                OioWorker.close(channel, future);
            }
        }
    }
}

