/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioDatagramChannel;
import com.flipkart.phantom.netty.uds.OioDatagramWorker;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;

class OioDatagramPipelineSink
extends AbstractChannelSink {
    private final Executor workerExecutor;

    OioDatagramPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioDatagramChannel channel = (OioDatagramChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    OioDatagramWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.disconnect(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    OioDatagramWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent evt = (MessageEvent)e;
            OioDatagramWorker.write(channel, future, evt.getMessage(), evt.getRemoteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(OioDatagramChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean workerStarted = false;
        try {
            channel.socket.bind(localAddress);
            bound = true;
            future.setSuccess();
            Channels.fireChannelBound((Channel)channel, (SocketAddress)channel.getLocalAddress());
            DeadLockProofWorker.start((Executor)this.workerExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)new OioDatagramWorker(channel), "Old I/O datagram worker (" + (Object)((Object)channel) + ')'));
            workerStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
        finally {
            if (bound && !workerStarted) {
                OioDatagramWorker.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(OioDatagramChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            channel.socket.connect(remoteAddress);
            connected = true;
            future.setSuccess();
            if (!bound) {
                Channels.fireChannelBound((Channel)channel, (SocketAddress)channel.getLocalAddress());
            }
            Channels.fireChannelConnected((Channel)channel, (SocketAddress)channel.getRemoteAddress());
            String threadName = "Old I/O datagram worker (" + (Object)((Object)channel) + ')';
            if (!bound) {
                DeadLockProofWorker.start((Executor)this.workerExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)new OioDatagramWorker(channel), threadName));
            } else {
                Thread workerThread = channel.workerThread;
                if (workerThread != null) {
                    try {
                        workerThread.setName(threadName);
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
            }
            workerStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
        finally {
            if (connected && !workerStarted) {
                OioDatagramWorker.close(channel, future);
            }
        }
    }
}

