/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioDatagramChannel;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;

class OioDatagramWorker
implements Runnable {
    private final OioDatagramChannel channel;

    OioDatagramWorker(OioDatagramChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.channel.workerThread = Thread.currentThread();
        MulticastSocket socket = this.channel.socket;
        while (this.channel.isOpen()) {
            Object object = this.channel.interestOpsLock;
            synchronized (object) {
                while (!this.channel.isReadable()) {
                    try {
                        this.channel.interestOpsLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.channel.isOpen()) continue;
                        break;
                    }
                }
            }
            ReceiveBufferSizePredictor predictor = this.channel.getConfig().getReceiveBufferSizePredictor();
            byte[] buf = new byte[predictor.nextReceiveBufferSize()];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            try {
                socket.receive(packet);
            }
            catch (InterruptedIOException e) {
                continue;
            }
            catch (Throwable t) {
                if (this.channel.socket.isClosed()) break;
                Channels.fireExceptionCaught((Channel)this.channel, (Throwable)t);
                break;
            }
            Channels.fireMessageReceived((Channel)this.channel, (Object)this.channel.getConfig().getBufferFactory().getBuffer(buf, 0, packet.getLength()), (SocketAddress)packet.getSocketAddress());
        }
        this.channel.workerThread = null;
        OioDatagramWorker.close(this.channel, Channels.succeededFuture((Channel)this.channel));
    }

    static void write(OioDatagramChannel channel, ChannelFuture future, Object message, SocketAddress remoteAddress) {
        try {
            DatagramPacket packet;
            ChannelBuffer buf = (ChannelBuffer)message;
            int offset = buf.readerIndex();
            int length = buf.readableBytes();
            ByteBuffer nioBuf = buf.toByteBuffer();
            if (nioBuf.hasArray()) {
                packet = new DatagramPacket(nioBuf.array(), nioBuf.arrayOffset() + offset, length);
            } else {
                byte[] arrayBuf = new byte[length];
                buf.getBytes(0, arrayBuf);
                packet = new DatagramPacket(arrayBuf, length);
            }
            if (remoteAddress != null) {
                packet.setSocketAddress(remoteAddress);
            }
            channel.socket.send(packet);
            Channels.fireWriteComplete((Channel)channel, (long)length);
            future.setSuccess();
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(OioDatagramChannel channel, ChannelFuture future, int interestOps) {
        block9: {
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block9;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                Channels.fireChannelInterestChanged((Channel)channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
            }
        }
    }

    static void disconnect(OioDatagramChannel channel, ChannelFuture future) {
        block5: {
            boolean connected = channel.isConnected();
            try {
                channel.socket.disconnect();
                future.setSuccess();
                if (!connected) break block5;
                Thread workerThread = channel.workerThread;
                if (workerThread != null) {
                    try {
                        workerThread.setName("Old I/O datagram worker (" + (Object)((Object)channel) + ')');
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                Channels.fireChannelDisconnected((Channel)channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
            }
        }
    }

    static void close(OioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    Channels.fireChannelDisconnected((Channel)channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound((Channel)channel);
                }
                Channels.fireChannelClosed((Channel)channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }
}

