/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioServerSocketChannel;
import com.flipkart.phantom.netty.uds.OioServerSocketPipelineSink;
import java.io.File;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.ServerSocketChannel;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.util.internal.ExecutorUtil;

public class OioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;
    private File socketFile;

    public OioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new OioServerSocketPipelineSink(workerExecutor);
    }

    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new OioServerSocketChannel((ChannelFactory)this, pipeline, this.sink);
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate((Executor[])new Executor[]{this.bossExecutor, this.workerExecutor});
    }

    public File getSocketFile() {
        return this.socketFile;
    }

    public void setSocketFile(File socketFile) {
        this.socketFile = socketFile;
        OioServerSocketPipelineSink sink = (OioServerSocketPipelineSink)this.sink;
        sink.setSocketFile(socketFile);
    }
}

