/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioAcceptedSocketChannel;
import com.flipkart.phantom.netty.uds.OioServerSocketChannel;
import com.flipkart.phantom.netty.uds.OioServerSocketChannelFactory;
import com.flipkart.phantom.netty.uds.OioSocketChannel;
import com.flipkart.phantom.netty.uds.OioWorker;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketException;

class OioServerSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketPipelineSink.class);
    final Executor workerExecutor;
    private File socketFile;
    private Boss bossInstance;

    OioServerSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof OioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof OioAcceptedSocketChannel) {
            this.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        OioServerSocketChannel channel = (OioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            OioAcceptedSocketChannel channel = (OioAcceptedSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    OioWorker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    OioWorker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    OioWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            OioSocketChannel channel = (OioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            Object message = event.getMessage();
            OioWorker.write(channel, future, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(OioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            channel.socket.bind(localAddress, channel.getConfig().getBacklog());
            bound = true;
            future.setSuccess();
            localAddress = channel.getLocalAddress();
            Channels.fireChannelBound((Channel)channel, (SocketAddress)localAddress);
            Executor bossExecutor = ((OioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
            this.bossInstance = new Boss(channel);
            DeadLockProofWorker.start((Executor)bossExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)this.bossInstance, "Old I/O server boss (" + (Object)((Object)channel) + ')'));
            bossStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
        finally {
            if (!bossStarted && bound) {
                this.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(OioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            this.bossInstance.stop();
            AFUNIXSocket sock = AFUNIXSocket.newInstance();
            try {
                sock.connect((SocketAddress)new AFUNIXSocketAddress(this.socketFile));
            }
            catch (AFUNIXSocketException e) {
                logger.warn("Failed to connect to Socket while sending a stop request.");
            }
            channel.socket.close();
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound((Channel)channel);
                    }
                    Channels.fireChannelClosed((Channel)channel);
                } else {
                    future.setSuccess();
                }
            }
            finally {
                channel.shutdownLock.unlock();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }

    public File getSocketFile() {
        return this.socketFile;
    }

    public void setSocketFile(File socketFile) {
        this.socketFile = socketFile;
    }

    private final class Boss
    implements Runnable {
        private final OioServerSocketChannel channel;
        private boolean isAlive = true;

        Boss(OioServerSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            this.channel.shutdownLock.lock();
            try {
                while (this.channel.isBound()) {
                    try {
                        Socket acceptedSocket = this.channel.socket.accept();
                        acceptedSocket.setSoTimeout(300);
                        if (!this.isAlive) {
                            logger.debug("Stopping boss thread");
                            return;
                        }
                        try {
                            ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                            OioAcceptedSocketChannel acceptedChannel = new OioAcceptedSocketChannel((Channel)this.channel, this.channel.getFactory(), pipeline, (ChannelSink)OioServerSocketPipelineSink.this, acceptedSocket);
                            DeadLockProofWorker.start((Executor)OioServerSocketPipelineSink.this.workerExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)new OioWorker(acceptedChannel), "Old I/O server worker (parentId: " + this.channel.getId() + ", " + (Object)((Object)this.channel) + ')'));
                        }
                        catch (Exception e) {
                            logger.warn("Failed to initialize an accepted socket.", (Throwable)e);
                            try {
                                acceptedSocket.close();
                            }
                            catch (IOException e2) {
                                logger.warn("Failed to close a partially accepted socket.", (Throwable)e2);
                            }
                        }
                    }
                    catch (SocketTimeoutException acceptedSocket) {
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (!this.channel.socket.isBound()) return;
                        if (this.channel.socket.isClosed()) {
                            return;
                        }
                        logger.warn("Failed to accept a connection.", e);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return;
            }
            finally {
                this.channel.shutdownLock.unlock();
                logger.debug("Channel unlocked by Boss Thread");
            }
        }

        public void stop() {
            this.isAlive = false;
        }
    }
}

