/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioAcceptedSocketChannel;
import com.flipkart.phantom.netty.uds.OioSocketChannel;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.regex.Pattern;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.DefaultFileRegion;
import org.jboss.netty.channel.FileRegion;

class OioWorker
implements Runnable {
    private static final Pattern SOCKET_CLOSED_MESSAGE = Pattern.compile("^.*(?:Socket.*closed).*$", 2);
    private final OioSocketChannel channel;

    OioWorker(OioSocketChannel channel) {
        this.channel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.channel.workerThread = Thread.currentThread();
        PushbackInputStream in = this.channel.getInputStream();
        boolean fireConnected = this.channel instanceof OioAcceptedSocketChannel;
        while (this.channel.isOpen()) {
            int readBytes;
            byte[] buf;
            block11: {
                if (fireConnected) {
                    fireConnected = false;
                    org.jboss.netty.channel.Channels.fireChannelConnected((Channel)this.channel, (SocketAddress)this.channel.getRemoteAddress());
                }
                Object object = this.channel.interestOpsLock;
                synchronized (object) {
                    while (!this.channel.isReadable()) {
                        try {
                            this.channel.interestOpsLock.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.channel.isOpen()) continue;
                            break;
                        }
                    }
                }
                try {
                    int bytesToRead = in.available();
                    if (bytesToRead > 0) {
                        buf = new byte[bytesToRead];
                        readBytes = in.read(buf);
                        break block11;
                    }
                    int b = in.read();
                    if (b < 0) break;
                    in.unread(b);
                    continue;
                }
                catch (Throwable t) {
                    if (this.channel.socket.isClosed()) break;
                    org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)this.channel, (Throwable)t);
                    break;
                }
            }
            org.jboss.netty.channel.Channels.fireMessageReceived((Channel)this.channel, (Object)this.channel.getConfig().getBufferFactory().getBuffer(buf, 0, readBytes));
        }
        this.channel.workerThread = null;
        OioWorker.close(this.channel, org.jboss.netty.channel.Channels.succeededFuture((Channel)this.channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(OioSocketChannel channel, ChannelFuture future, Object message) {
        OutputStream out = channel.getOutputStream();
        if (out == null) {
            ClosedChannelException e = new ClosedChannelException();
            future.setFailure((Throwable)e);
            org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)channel, (Throwable)e);
            return;
        }
        try {
            int length;
            block16: {
                length = 0;
                if (message instanceof FileRegion) {
                    FileRegion fr = (FileRegion)message;
                    try {
                        OutputStream outputStream = out;
                        synchronized (outputStream) {
                            WritableByteChannel bchannel = Channels.newChannel(out);
                            long i = 0L;
                            while ((i = fr.transferTo(bchannel, (long)length)) > 0L && (long)(length = (int)((long)length + i)) < fr.getCount()) {
                            }
                            break block16;
                        }
                    }
                    finally {
                        if (fr instanceof DefaultFileRegion && ((DefaultFileRegion)fr).releaseAfterTransfer()) {
                            fr.releaseExternalResources();
                        }
                    }
                }
                ChannelBuffer a = (ChannelBuffer)message;
                length = a.readableBytes();
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    a.getBytes(a.readerIndex(), out, length);
                }
            }
            org.jboss.netty.channel.Channels.fireWriteComplete((Channel)channel, (long)length);
            future.setSuccess();
        }
        catch (Throwable t2) {
            ClosedChannelException t2;
            if (t2 instanceof SocketException && SOCKET_CLOSED_MESSAGE.matcher(String.valueOf(t2.getMessage())).matches()) {
                t2 = new ClosedChannelException();
            }
            future.setFailure((Throwable)t2);
            org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)channel, (Throwable)t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(OioSocketChannel channel, ChannelFuture future, int interestOps) {
        block9: {
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInterestOpsNow(1);
                    } else {
                        channel.setInterestOpsNow(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block9;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInterestOpsNow(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                org.jboss.netty.channel.Channels.fireChannelInterestChanged((Channel)channel);
            }
            catch (Throwable t) {
                future.setFailure(t);
                org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
            }
        }
    }

    static void close(OioSocketChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                    org.jboss.netty.channel.Channels.fireChannelDisconnected((Channel)channel);
                }
                if (bound) {
                    org.jboss.netty.channel.Channels.fireChannelUnbound((Channel)channel);
                }
                org.jboss.netty.channel.Channels.fireChannelClosed((Channel)channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            org.jboss.netty.channel.Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }
}

