/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty;

import com.flipkart.phantom.netty.uds.OioServerSocketChannelFactory;
import com.flipkart.phantom.runtime.impl.server.concurrent.NamedThreadFactory;
import com.flipkart.phantom.runtime.impl.server.netty.AbstractNettyNetworkServer;
import com.flipkart.phantom.runtime.spi.server.NetworkServer;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class UDSNettyServer
extends AbstractNettyNetworkServer {
    private static final Logger LOGGER = LogFactory.getLogger(UDSNettyServer.class);
    private static final int INVALID_POOL_SIZE = -1;
    private static final String DEFAULT_JUNIX_NATIVE_DIRECTORY = "uds-lib";
    private static final String JUNIX_LIB_SYSTEM_PROPERTY = "org.newsclub.net.unix.library.path";
    private int serverPoolSize = -1;
    private int workerPoolSize = -1;
    private ExecutorService serverExecutors;
    private ExecutorService workerExecutors;
    private String junixNativeLibDirectoryName = "uds-lib";
    private String socketName;
    private String socketDir;
    private File socketFile;

    public NetworkServer.TransmissionProtocol getTransmissionProtocol() {
        return NetworkServer.TRANSMISSION_PROTOCOL.UDS;
    }

    public void afterPropertiesSet() throws Exception {
        File[] junixDirectories = FileLocator.findDirectories((String)this.junixNativeLibDirectoryName, null);
        if (junixDirectories == null || junixDirectories.length == 0) {
            throw new RuntimeException("Did not find junixDirectory: " + this.junixNativeLibDirectoryName);
        }
        LOGGER.info("Found junixDirectory: " + junixDirectories[0].getAbsolutePath());
        System.setProperty(JUNIX_LIB_SYSTEM_PROPERTY, junixDirectories[0].getAbsolutePath());
        Assert.notNull((Object)this.socketDir, (String)"socketDir is a required property for UDSNetworkServer");
        Assert.notNull((Object)this.socketName, (String)"socketName is a required property for UDSNetworkServer");
        this.socketFile = new File(new File(this.socketDir), this.socketName);
        LOGGER.info("Socket file: " + this.socketFile.getAbsolutePath());
        try {
            this.socketAddress = new AFUNIXSocketAddress(this.socketFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating Socket Address. ", e);
        }
        if (this.getServerExecutors() == null) {
            if (this.getServerPoolSize() != -1) {
                this.setServerExecutors(Executors.newFixedThreadPool(this.getServerPoolSize(), (ThreadFactory)new NamedThreadFactory("UDSServer-Listener")));
            } else {
                this.setServerExecutors(Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("UDSServer-Listener")));
            }
        }
        if (this.getWorkerExecutors() == null) {
            if (this.getWorkerPoolSize() != -1) {
                this.setWorkerExecutors(Executors.newFixedThreadPool(this.getWorkerPoolSize(), (ThreadFactory)new NamedThreadFactory("UDSServer-Worker")));
            } else {
                this.setWorkerExecutors(Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("UDSServer-Worker")));
            }
        }
        super.afterPropertiesSet();
        LOGGER.info("UDS Server startup complete");
    }

    public String getServerType() {
        return "UDS Netty Service";
    }

    public String getServerEndpoint() {
        return this.socketDir + this.socketFile.getAbsolutePath();
    }

    public String toString() {
        return "UDSNetworkServer [socketFile=" + this.socketFile.getAbsolutePath() + "] " + this.getPipelineFactory();
    }

    protected Bootstrap createServerBootstrap() throws RuntimeException {
        Assert.notNull((Object)this.socketFile, (String)"Socket File should not be null");
        OioServerSocketChannelFactory serverSocketChannelFactory = new OioServerSocketChannelFactory((Executor)this.getServerExecutors(), (Executor)this.getWorkerExecutors());
        serverSocketChannelFactory.setSocketFile(this.socketFile);
        return new ServerBootstrap((ChannelFactory)serverSocketChannelFactory);
    }

    protected Channel createChannel() throws RuntimeException {
        if (this.getServerBootstrap() == null) {
            throw new RuntimeException("Error creating Channel. Bootstrap instance cannot be null. See UDSNetworkServer#createServerBootstrap()");
        }
        return ((ServerBootstrap)this.serverBootstrap).bind((SocketAddress)this.socketAddress);
    }

    public int getServerPoolSize() {
        return this.serverPoolSize;
    }

    public void setServerPoolSize(int serverPoolSize) {
        this.serverPoolSize = serverPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public ExecutorService getServerExecutors() {
        return this.serverExecutors;
    }

    public void setServerExecutors(ExecutorService serverExecutors) {
        this.serverExecutors = serverExecutors;
    }

    public ExecutorService getWorkerExecutors() {
        return this.workerExecutors;
    }

    public void setWorkerExecutors(ExecutorService workerExecutors) {
        this.workerExecutors = workerExecutors;
    }

    public String getSocketDir() {
        return this.socketDir;
    }

    public void setSocketDir(String socketDir) {
        this.socketDir = socketDir;
    }

    public String getSocketName() {
        return this.socketName;
    }

    public void setSocketName(String socketName) {
        this.socketName = socketName;
    }

    public String getJunixNativeLibDirectoryName() {
        return this.junixNativeLibDirectoryName;
    }

    public void setJunixNativeLibDirectoryName(String junixNativeLibDirectoryName) {
        this.junixNativeLibDirectoryName = junixNativeLibDirectoryName;
    }
}

