/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server;

import com.flipkart.phantom.runtime.spi.server.NetworkServer;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractNetworkServer
implements NetworkServer,
InitializingBean,
DisposableBean {
    protected static final int DEFAULT_PORT = 8181;
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractNetworkServer.class);
    protected InetSocketAddress socketAddress;
    protected int portNumber = 8181;

    public void afterPropertiesSet() throws Exception {
    }

    public void init() throws Exception {
        if (this.getSocketAddress() != null) {
            this.startServer(this.getSocketAddress());
        } else {
            this.startServer(this.getPortNumber());
        }
    }

    @Override
    public void startServer() throws RuntimeException {
        this.startServer(8181);
    }

    @Override
    public void startServer(int port) throws RuntimeException {
        this.portNumber = port;
        this.startServer(new InetSocketAddress(this.portNumber));
    }

    @Override
    public void startServer(InetSocketAddress socketAddress) throws RuntimeException {
        this.socketAddress = socketAddress;
        this.doStartServer();
        LOGGER.info("Network Server : {} started", (Object)this.toString());
    }

    @Override
    public void stopServer() throws RuntimeException {
        this.doStopServer();
        LOGGER.info("Network Server : {} stopped", (Object)this.toString());
    }

    public void destroy() throws Exception {
        this.stopServer();
    }

    protected abstract void doStartServer() throws RuntimeException;

    protected abstract void doStopServer() throws RuntimeException;

    public abstract String getServerType();

    public abstract String getServerEndpoint();

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public void setSocketAddress(InetSocketAddress socketAddress) {
        this.socketAddress = socketAddress;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }
}

