/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.decoder.command;

import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandBufferDecoder
extends FrameDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBufferDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int beginIndex = buffer.readerIndex();
        buffer.markReaderIndex();
        CommandInterpreter.ProxyCommand proxyCommand = new CommandInterpreter().interpretCommand(buffer);
        if (proxyCommand.getReadFailure() != null && proxyCommand.getReadFailure() == CommandInterpreter.ReadFailure.INSUFFICIENT_DATA) {
            LOGGER.debug("Frame decode failed due to insufficient data. Message is : " + proxyCommand.getReadFailureDescription());
            buffer.resetReaderIndex();
            return null;
        }
        int endIndex = buffer.readerIndex();
        buffer.resetReaderIndex();
        return buffer.readSlice(endIndex - beginIndex);
    }
}

