/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty;

import com.flipkart.phantom.runtime.impl.server.AbstractNetworkServer;
import com.flipkart.phantom.runtime.impl.server.netty.ChannelHandlerPipelineFactory;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.springframework.util.Assert;

public abstract class AbstractNettyNetworkServer
extends AbstractNetworkServer {
    protected ChannelGroup defaultChannelGroup;
    protected Bootstrap serverBootstrap;
    protected ChannelHandlerPipelineFactory pipelineFactory;
    private Map<String, Object> bootstrapOptions = new HashMap<String, Object>();

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.pipelineFactory, (String)"The 'pipelineFactory' may not be null");
        this.serverBootstrap = this.createServerBootstrap();
        this.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFactory);
        this.serverBootstrap.setOptions(this.bootstrapOptions);
        super.afterPropertiesSet();
    }

    @Override
    protected void doStartServer() throws RuntimeException {
        this.defaultChannelGroup.add((Object)this.createChannel());
    }

    @Override
    protected void doStopServer() throws RuntimeException {
        ChannelGroupFuture future = this.defaultChannelGroup.close();
        future.awaitUninterruptibly();
        this.pipelineFactory.close();
        this.serverBootstrap.releaseExternalResources();
    }

    protected abstract Bootstrap createServerBootstrap() throws RuntimeException;

    protected abstract Channel createChannel() throws RuntimeException;

    public Bootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public ChannelHandlerPipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public void setPipelineFactory(ChannelHandlerPipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
    }

    public Map<String, Object> getBootstrapOptions() {
        return this.bootstrapOptions;
    }

    public void setBootstrapOptions(Map<String, Object> bootstrapOptions) {
        this.bootstrapOptions = bootstrapOptions;
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }
}

