/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigFileUtils {
    private static final String BATCH_JOB_TAG = "batch:job";
    private static final String ID_PROP = "id";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileUtils.class);

    public static List<String> getHandlerNames(Resource configFile) {
        return ConfigFileUtils.getHandlerNames(new ByteArrayResource(ConfigFileUtils.getContents(configFile).getBytes()));
    }

    public static List<String> getHandlerNames(ByteArrayResource configFile) {
        LinkedList<String> jobNameList = new LinkedList<String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(configFile.getInputStream());
            Element docEle = dom.getDocumentElement();
            NodeList nl = docEle.getElementsByTagName(BATCH_JOB_TAG);
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (!el.hasAttribute(ID_PROP)) continue;
                    jobNameList.add(el.getAttribute(ID_PROP));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to get the job name from the given Spring Batch configuration file", (Throwable)e);
            throw new PlatformException((Throwable)e);
        }
        return jobNameList;
    }

    public static String getContents(Resource resource) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)resource.getInputStream(), (Writer)writer, (String)"UTF-8");
        }
        catch (IOException e) {
            LOGGER.error("Exception while reading file " + resource.getFilename(), (Throwable)e);
        }
        return writer.toString();
    }
}

