/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private ChannelGroup defaultChannelGroup;
    private ExecutorRepository repository;
    private ServiceProxyEventProducer eventProducer;
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        long receiveTime = System.currentTimeMillis();
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
            LOGGER.debug("Read Command : " + readCommand);
            String pool = readCommand.getCommandParams().get(POOL_PARAM);
            TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
            taskRequestWrapper.setData(readCommand.getCommandData());
            taskRequestWrapper.setParams(readCommand.getCommandParams());
            TaskHandlerExecutor executor = pool != null ? (TaskHandlerExecutor)this.repository.getExecutor(readCommand.getCommand(), pool, (RequestWrapper)taskRequestWrapper) : (TaskHandlerExecutor)this.repository.getExecutor(readCommand.getCommand(), readCommand.getCommand(), (RequestWrapper)taskRequestWrapper);
            try {
                try {
                    TaskResult result = null;
                    if (executor.getCallInvocationType() == 0) {
                        result = (TaskResult)executor.execute();
                    } else {
                        executor.queue();
                        result = new TaskResult(true, "The command dispatched for async execution");
                    }
                    LOGGER.debug("The output is: " + result);
                    commandInterpreter.writeCommandExecutionResponse(ctx, event, result);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in executing command : " + readCommand, e);
                }
            }
            finally {
                if (this.eventProducer != null) {
                    String requestID = readCommand.getCommandParams().get("requestID");
                    ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                    eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                    this.eventProducer.publishEvent(eventBuilder.build());
                } else {
                    LOGGER.debug("eventProducer not set, not publishing event");
                }
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public ExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

