/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring.web;

import com.flipkart.phantom.runtime.impl.spring.utils.ConfigFileUtils;
import com.flipkart.phantom.runtime.spi.spring.admin.SPConfigService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class HandlerConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerConfigController.class);
    private SPConfigService configService;

    @ModelAttribute(value="handlerName")
    public String getJobName(HttpServletRequest request) {
        String path = request.getServletPath();
        int index = path.lastIndexOf("handler/") + 8;
        if (index >= 0) {
            path = path.substring(index);
        }
        return path;
    }

    @RequestMapping(value={"/configuration"}, method={RequestMethod.GET})
    public String configuration(ModelMap model, HttpServletRequest request) {
        model.addAttribute("handlers", this.configService.getAllHandlers());
        model.addAttribute("networkServers", this.configService.getDeployedNetworkServers());
        return "configuration";
    }

    @RequestMapping(value={"/viewConfig/**"}, method={RequestMethod.GET})
    public String viewConfig(ModelMap model, HttpServletRequest request, @ModelAttribute(value="handlerName") String handlerName) {
        model.addAttribute("handlers", this.configService.getAllHandlers());
        Resource handlerFile = this.configService.getHandlerConfig(handlerName);
        if (handlerFile == null) {
            model.addAttribute("XMLFileContents", (Object)"Sorry, this file cannot be viewed. Maybe this TaskHandler wasn't defined in spring-proxy-handler-config.xml");
        } else {
            model.addAttribute("XMLFileContents", (Object)ConfigFileUtils.getContents(handlerFile));
        }
        return "viewConfig";
    }

    @RequestMapping(value={"/reInit/**"}, method={RequestMethod.GET})
    public String reInitHandler(ModelMap model, HttpServletRequest request, @ModelAttribute(value="handlerName") String handlerName) {
        String message;
        try {
            this.configService.reinitHandler(handlerName);
            message = "Successfully reinitialized handler " + handlerName;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            message = "Error while reinitializing handler: \n";
            message = message + sw.toString() + "\n";
            if (e.getCause() != null) {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.getCause().printStackTrace(pw);
                message = message + "Caused by: ";
                message = message + sw.toString() + "\n";
            }
            LOGGER.error("Error reinitializing handler " + handlerName, (Throwable)e);
        }
        model.addAttribute("message", (Object)message);
        return "message";
    }

    @RequestMapping(value={"/deploy/**"}, method={RequestMethod.POST})
    public String deployModifiedConfig(ModelMap model, HttpServletRequest request, @ModelAttribute(value="handlerName") String handlerName, @RequestParam(defaultValue="") String XMLFileContents, @RequestParam(defaultValue="0") String identifier) {
        XMLFileContents = XMLFileContents.trim();
        if (identifier.equals("Save")) {
            try {
                this.configService.modifyHandlerConfig(handlerName, new ByteArrayResource(XMLFileContents.getBytes()));
            }
            catch (Exception e) {
                model.addAttribute("XMLFileError", (Object)"Unable to deploy file");
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                model.addAttribute("LoadingError", (Object)errors.toString());
                if (errors.toString() == null) {
                    model.addAttribute("LoadingError", (Object)"Unexpected error");
                }
                model.addAttribute("XMLFileContents", (Object)ConfigFileUtils.getContents(this.configService.getHandlerConfig(handlerName)));
                return "modifyConfig";
            }
        }
        model.addAttribute("SuccessMessage", (Object)"Successfully Deployed the new Handler Configuration");
        model.addAttribute("taskHandlers", this.configService.getAllHandlers());
        Resource handlerFile = this.configService.getHandlerConfig(handlerName);
        model.addAttribute("XMLFileContents", (Object)ConfigFileUtils.getContents(handlerFile));
        try {
            model.addAttribute("XMLFileName", (Object)handlerFile.getURI());
        }
        catch (IOException e) {
            model.addAttribute("XMLFileName", (Object)"File not found");
        }
        return "viewConfig";
    }

    @RequestMapping(value={"**/modifyConfig/**"}, method={RequestMethod.GET})
    public String modifyConfig(ModelMap model, HttpServletRequest request, @ModelAttribute(value="handlerName") String handlerName, @RequestParam(defaultValue="") String XMLFileContents, @RequestParam(defaultValue="0") String identifier) {
        model.addAttribute("taskHandlers", this.configService.getAllHandlers());
        model.addAttribute("servletPath", (Object)request.getContextPath());
        Resource handlerFile = this.configService.getHandlerConfig(handlerName);
        model.addAttribute("XMLFileContents", (Object)ConfigFileUtils.getContents(handlerFile));
        try {
            model.addAttribute("XMLFileName", (Object)handlerFile.getURI());
        }
        catch (IOException e) {
            model.addAttribute("XMLFileName", (Object)"File not found");
        }
        return "modifyConfig";
    }

    public SPConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(SPConfigService configService) {
        this.configService = configService;
    }
}

