/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskHandlerExecutorRepository;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private ChannelGroup defaultChannelGroup;
    private TaskHandlerExecutorRepository repository;
    private ServiceProxyEventProducer eventProducer;
    private static final String ASYNC_COMMAND_HANDLER = "ASYNC_COMMAND_HANDLER";

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        block12: {
            long receiveTime = System.currentTimeMillis();
            if (MessageEvent.class.isAssignableFrom(event.getClass())) {
                CommandInterpreter commandInterpreter = new CommandInterpreter();
                CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
                LOGGER.debug("Read Command : " + readCommand);
                String pool = readCommand.getCommandParams().get(POOL_PARAM);
                String commandName = readCommand.getCommand();
                String poolName = pool != null ? pool : commandName;
                TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
                taskRequestWrapper.setData(readCommand.getCommandData());
                taskRequestWrapper.setParams(readCommand.getCommandParams());
                TaskHandlerExecutor executor = (TaskHandlerExecutor)this.repository.getExecutor(commandName, poolName, (RequestWrapper)taskRequestWrapper);
                try {
                    try {
                        this.repository.executeAsyncCommand(commandName, poolName, (RequestWrapper)taskRequestWrapper);
                        LOGGER.debug("Successfully started execution for async command " + commandName);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error asynchronously executing the command", (Throwable)e);
                        if (this.eventProducer != null) {
                            String requestID = readCommand.getCommandParams().get("requestID");
                            ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), ASYNC_COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                            eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                            this.eventProducer.publishEvent(eventBuilder.build());
                        } else {
                            LOGGER.debug("eventProducer not set, not publishing event");
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (this.eventProducer != null) {
                        String requestID = readCommand.getCommandParams().get("requestID");
                        ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), ASYNC_COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                        eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                        this.eventProducer.publishEvent(eventBuilder.build());
                    } else {
                        LOGGER.debug("eventProducer not set, not publishing event");
                    }
                    throw throwable;
                }
                if (this.eventProducer != null) {
                    String requestID = readCommand.getCommandParams().get("requestID");
                    ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), ASYNC_COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                    eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                    this.eventProducer.publishEvent(eventBuilder.build());
                } else {
                    LOGGER.debug("eventProducer not set, not publishing event");
                }
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public TaskHandlerExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskHandlerExecutorRepository repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

