/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.hystrix;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class HystrixMetricsSnapshotServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HystrixCommandKey key;
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter responseJsonString = new StringWriter();
        JsonGenerator responseJson = jsonFactory.createJsonGenerator((Writer)responseJsonString);
        responseJson.writeStartObject();
        responseJson.writeArrayFieldStart("HystrixCommand");
        for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
            responseJson.writeStartObject();
            key = commandMetrics.getCommandKey();
            responseJson.writeStringField("name", key.name());
            responseJson.writeStringField("group", commandMetrics.getCommandGroup().name());
            HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
            responseJson.writeNumberField("errorCount", healthCounts.getErrorCount());
            responseJson.writeNumberField("requestCount", healthCounts.getTotalRequests());
            responseJson.writeNumberField("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            responseJson.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            responseJson.writeNumberField("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            responseJson.writeNumberField("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            responseJson.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            responseJson.writeNumberField("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            responseJson.writeNumberField("latencyTotal_mean", commandMetrics.getTotalTimeMean());
            responseJson.writeObjectFieldStart("latencyTotal");
            responseJson.writeNumberField("0", commandMetrics.getTotalTimePercentile(0.0));
            responseJson.writeNumberField("25", commandMetrics.getTotalTimePercentile(25.0));
            responseJson.writeNumberField("50", commandMetrics.getTotalTimePercentile(50.0));
            responseJson.writeNumberField("75", commandMetrics.getTotalTimePercentile(75.0));
            responseJson.writeNumberField("90", commandMetrics.getTotalTimePercentile(90.0));
            responseJson.writeNumberField("95", commandMetrics.getTotalTimePercentile(95.0));
            responseJson.writeNumberField("99", commandMetrics.getTotalTimePercentile(99.0));
            responseJson.writeNumberField("99.5", commandMetrics.getTotalTimePercentile(99.5));
            responseJson.writeNumberField("100", commandMetrics.getTotalTimePercentile(100.0));
            responseJson.writeEndObject();
            responseJson.writeEndObject();
        }
        responseJson.writeEndArray();
        responseJson.writeArrayFieldStart("HystrixThreadPool");
        for (HystrixThreadPoolMetrics threadPoolMetrics : HystrixThreadPoolMetrics.getInstances()) {
            responseJson.writeStartObject();
            key = threadPoolMetrics.getThreadPoolKey();
            responseJson.writeStringField("name", key.name());
            responseJson.writeNumberField("currentActiveCount", threadPoolMetrics.getCurrentActiveCount().intValue());
            responseJson.writeNumberField("currentQueueSize", threadPoolMetrics.getCurrentQueueSize().intValue());
            responseJson.writeEndObject();
        }
        responseJson.writeEndArray();
        responseJson.writeEndObject();
        responseJson.close();
        response.setHeader("Content-Type", "application/json;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.getWriter().println(responseJsonString.getBuffer().toString() + "\n");
        response.flushBuffer();
    }
}

