/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring.web;

import com.flipkart.phantom.runtime.impl.hystrix.HystrixMetricsAggregator;
import com.flipkart.phantom.task.spi.AbstractHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class HystrixMetricsSnapshotController<T extends AbstractHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixMetricsSnapshotController.class);
    HystrixMetricsAggregator hystrixMetricsAggregator = null;

    @RequestMapping(value={"/hystrix.snapshot.global"}, method={RequestMethod.GET})
    @ResponseBody
    public String handleRequest(ModelMap model, HttpServletRequest request) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter responseJsonString = new StringWriter();
        JsonGenerator responseJson = jsonFactory.createJsonGenerator((Writer)responseJsonString);
        responseJson.writeStartObject();
        Map<String, Map<String, Map<String, Long>>> lastOneMinuteMetrics = this.hystrixMetricsAggregator.getMetricsSnapshotReporter().getMetricsLastDuration();
        responseJson.writeArrayFieldStart("HystrixCommand");
        if (lastOneMinuteMetrics != null && lastOneMinuteMetrics.get("HystrixCommand") != null) {
            for (String commandName : lastOneMinuteMetrics.get("HystrixCommand").keySet()) {
                Map<String, Long> commandMetrics = lastOneMinuteMetrics.get("HystrixCommand").get(commandName);
                String[] a = commandName.split("\\.");
                responseJson.writeStartObject();
                responseJson.writeStringField("name", a[1]);
                responseJson.writeStringField("group", a[0]);
                responseJson.writeNumberField("errorCount", commandMetrics.get("errorCount").longValue());
                responseJson.writeNumberField("requestCount", commandMetrics.get("requestCount").longValue());
                responseJson.writeNumberField("rollingCountFailure", commandMetrics.get("rollingCountFailure").longValue());
                responseJson.writeNumberField("rollingCountSemaphoreRejected", commandMetrics.get("rollingCountSemaphoreRejected").longValue());
                responseJson.writeNumberField("rollingCountShortCircuited", commandMetrics.get("rollingCountShortCircuited").longValue());
                responseJson.writeNumberField("rollingCountThreadPoolRejected", commandMetrics.get("rollingCountThreadPoolRejected").longValue());
                responseJson.writeNumberField("rollingCountSuccess", commandMetrics.get("rollingCountSuccess").longValue());
                responseJson.writeNumberField("rollingCountTimeout", commandMetrics.get("rollingCountTimeout").longValue());
                responseJson.writeNumberField("latencyTotal_mean", commandMetrics.get("latencyTotal_mean").longValue());
                responseJson.writeObjectFieldStart("latencyTotal");
                responseJson.writeNumberField("0", commandMetrics.get("0").longValue());
                responseJson.writeNumberField("25", commandMetrics.get("25").longValue());
                responseJson.writeNumberField("50", commandMetrics.get("50").longValue());
                responseJson.writeNumberField("75", commandMetrics.get("75").longValue());
                responseJson.writeNumberField("90", commandMetrics.get("90").longValue());
                responseJson.writeNumberField("95", commandMetrics.get("95").longValue());
                responseJson.writeNumberField("99", commandMetrics.get("99").longValue());
                responseJson.writeNumberField("99.5", commandMetrics.get("99.5").longValue());
                responseJson.writeNumberField("100", commandMetrics.get("100").longValue());
                responseJson.writeEndObject();
                responseJson.writeEndObject();
            }
        }
        responseJson.writeEndArray();
        responseJson.writeArrayFieldStart("HystrixThreadPool");
        if (lastOneMinuteMetrics != null && lastOneMinuteMetrics.get("HystrixThreadPool") != null) {
            for (String commandName : lastOneMinuteMetrics.get("HystrixThreadPool").keySet()) {
                responseJson.writeStartObject();
                responseJson.writeStringField("name", commandName);
                responseJson.writeNumberField("currentActiveCount", lastOneMinuteMetrics.get("HystrixThreadPool").get(commandName).get("currentActiveCount").longValue());
                responseJson.writeNumberField("currentQueueSize", lastOneMinuteMetrics.get("HystrixThreadPool").get(commandName).get("currentQueueSize").longValue());
                responseJson.writeEndObject();
            }
        }
        responseJson.writeEndArray();
        responseJson.writeEndObject();
        responseJson.close();
        return String.valueOf(responseJsonString.getBuffer().toString()) + "\n";
    }

    public void setHystrixMetricsAggregator(HystrixMetricsAggregator hystrixMetricsAggregator) {
        this.hystrixMetricsAggregator = hystrixMetricsAggregator;
    }
}

