/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty;

import com.flipkart.phantom.runtime.impl.server.concurrent.NamedThreadFactory;
import com.flipkart.phantom.runtime.impl.server.netty.AbstractNettyNetworkServer;
import com.flipkart.phantom.runtime.spi.server.NetworkServer;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class TCPNettyServer
extends AbstractNettyNetworkServer {
    private static final int INVALID_POOL_SIZE = -1;
    private int serverPoolSize = -1;
    private int workerPoolSize = -1;
    private int executorQueueSize = Runtime.getRuntime().availableProcessors() * 12;
    private ExecutorService serverExecutors;
    private ExecutorService workerExecutors;
    private String serverType = "TCP Netty Server";

    @Override
    public NetworkServer.TransmissionProtocol getTransmissionProtocol() {
        return NetworkServer.TRANSMISSION_PROTOCOL.TCP;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getServerExecutors() == null) {
            if (this.getServerPoolSize() != -1) {
                this.setServerExecutors(new ThreadPoolExecutor(this.getServerPoolSize(), this.getServerPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.getExecutorQueueSize()), new NamedThreadFactory("TCPServer-Listener"), new ThreadPoolExecutor.CallerRunsPolicy()));
            } else {
                this.setServerExecutors(Executors.newCachedThreadPool(new NamedThreadFactory("TCPServer-Listener")));
            }
        }
        if (this.getWorkerExecutors() == null) {
            if (this.getWorkerPoolSize() != -1) {
                this.setWorkerExecutors(new ThreadPoolExecutor(this.getWorkerPoolSize(), this.getWorkerPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.getExecutorQueueSize()), new NamedThreadFactory("TCPServer-Worker"), new ThreadPoolExecutor.CallerRunsPolicy()));
            } else {
                this.setWorkerExecutors(Executors.newCachedThreadPool(new NamedThreadFactory("TCPServer-Worker")));
            }
        }
        super.afterPropertiesSet();
    }

    public String toString() {
        return "TCPNettyServer [socketAddress=" + this.socketAddress + ", portNumber=" + this.portNumber + "] " + this.getPipelineFactory();
    }

    @Override
    protected Bootstrap createServerBootstrap() throws RuntimeException {
        return new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)this.getServerExecutors(), (Executor)this.getWorkerExecutors()));
    }

    @Override
    protected Channel createChannel() throws RuntimeException {
        if (this.getServerBootstrap() == null) {
            throw new RuntimeException("Error creating Channel. Bootstrap instance cannot be null. See TCPNettyServer#createServerBootstrap()");
        }
        return ((ServerBootstrap)this.serverBootstrap).bind((SocketAddress)this.socketAddress);
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Override
    public String getServerEndpoint() {
        return "" + this.portNumber;
    }

    public int getServerPoolSize() {
        return this.serverPoolSize;
    }

    public void setServerPoolSize(int serverPoolSize) {
        this.serverPoolSize = serverPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public void setWorkerPoolSize(int workerPoolSize) {
        this.workerPoolSize = workerPoolSize;
    }

    public ExecutorService getServerExecutors() {
        return this.serverExecutors;
    }

    public void setServerExecutors(ExecutorService serverExecutors) {
        this.serverExecutors = serverExecutors;
    }

    public ExecutorService getWorkerExecutors() {
        return this.workerExecutors;
    }

    public void setWorkerExecutors(ExecutorService workerExecutors) {
        this.workerExecutors = workerExecutors;
    }

    public int getExecutorQueueSize() {
        return this.executorQueueSize;
    }

    public void setExecutorQueueSize(int executorQueueSize) {
        this.executorQueueSize = executorQueueSize;
    }
}

