/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.hystrix.impl;

import com.flipkart.phantom.runtime.impl.hystrix.MetricsSnapshotReporter;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.HashMap;
import java.util.Map;

public class MetricsSnapshotReporterDefault
implements MetricsSnapshotReporter {
    public Map<String, Map<String, Map<String, Long>>> lastOneMinMetrics = new HashMap<String, Map<String, Map<String, Long>>>();

    @Override
    public Map<String, Map<String, Map<String, Long>>> getMetricsLastDuration() {
        HashMap<String, Long> currStats;
        String commandName;
        for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
            commandName = String.valueOf(commandMetrics.getCommandGroup().name()) + "." + commandMetrics.getCommandKey().name();
            if (this.lastOneMinMetrics.get("HystrixCommand") == null) {
                this.lastOneMinMetrics.put("HystrixCommand", new HashMap());
            }
            currStats = new HashMap();
            HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
            currStats.put("errorCount", healthCounts.getErrorCount());
            currStats.put("requestCount", healthCounts.getTotalRequests());
            currStats.put("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE));
            currStats.put("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED));
            currStats.put("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED));
            currStats.put("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS));
            currStats.put("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED));
            currStats.put("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT));
            currStats.put("latencyTotal_mean", Long.valueOf(commandMetrics.getTotalTimeMean()));
            currStats.put("0", Long.valueOf(commandMetrics.getTotalTimePercentile(0.0)));
            currStats.put("25", Long.valueOf(commandMetrics.getTotalTimePercentile(25.0)));
            currStats.put("50", Long.valueOf(commandMetrics.getTotalTimePercentile(50.0)));
            currStats.put("75", Long.valueOf(commandMetrics.getTotalTimePercentile(75.0)));
            currStats.put("90", Long.valueOf(commandMetrics.getTotalTimePercentile(90.0)));
            currStats.put("95", Long.valueOf(commandMetrics.getTotalTimePercentile(95.0)));
            currStats.put("99", Long.valueOf(commandMetrics.getTotalTimePercentile(99.0)));
            currStats.put("99.5", Long.valueOf(commandMetrics.getTotalTimePercentile(99.5)));
            currStats.put("100", Long.valueOf(commandMetrics.getTotalTimePercentile(100.0)));
            this.lastOneMinMetrics.get("HystrixCommand").put(commandName, currStats);
        }
        for (HystrixCommandMetrics commandMetrics : HystrixThreadPoolMetrics.getInstances()) {
            commandName = commandMetrics.getThreadPoolKey().name();
            if (this.lastOneMinMetrics.get("HystrixThreadPool") == null) {
                this.lastOneMinMetrics.put("HystrixThreadPool", new HashMap());
            }
            currStats = new HashMap<String, Long>();
            currStats.put("currentActiveCount", commandMetrics.getCurrentActiveCount().longValue());
            currStats.put("currentQueueSize", commandMetrics.getCurrentQueueSize().longValue());
            this.lastOneMinMetrics.get("HystrixThreadPool").put(commandName, currStats);
        }
        return this.lastOneMinMetrics;
    }
}

