/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final String DEFAULT_THREAD_NAME_PREFIX = "ServiceProxy-Runtime-Thread";
    private static AtomicInteger threadCounter = new AtomicInteger(1);
    private String name = "ServiceProxy-Runtime-Thread";
    private boolean daemon;
    private int priority;

    public NamedThreadFactory(String name) {
        this(name, false, Thread.currentThread().getPriority());
    }

    public NamedThreadFactory(String name, boolean daemon) {
        this(name, daemon, Thread.currentThread().getPriority());
    }

    public NamedThreadFactory(String name, boolean daemon, int priority) {
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, String.valueOf(this.name) + "-" + threadCounter.getAndIncrement());
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        return thread;
    }
}

