/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ChannelHandlerPipelineFactory
implements ChannelPipelineFactory,
ApplicationContextAware {
    private static final long DFFAULT_IDLE_TIME_MILLIS = 200L;
    private long channelIdleTimeMillis = 200L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelHandlerPipelineFactory.class);
    private Timer timer;
    private String idleStateAwareChannelHandlerBean;
    private ApplicationContext applicationContext;
    private Map<String, String> channelHandlerBeanNamesMap = new HashMap<String, String>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        if (this.getIdleStateAwareChannelHandlerBean() != null) {
            channelPipeline.addLast("idleStateCheck", (ChannelHandler)new IdleStateHandler(this.timer, 0L, 0L, this.getChannelIdleTimeMillis(), TimeUnit.MILLISECONDS));
            channelPipeline.addLast("idleCheckHandler", (ChannelHandler)this.applicationContext.getBean(this.getIdleStateAwareChannelHandlerBean()));
        }
        for (String handlerKey : this.getChannelHandlerBeanNamesMap().keySet()) {
            channelPipeline.addLast(handlerKey, (ChannelHandler)this.applicationContext.getBean(this.getChannelHandlerBeanNamesMap().get(handlerKey)));
        }
        return channelPipeline;
    }

    public void close() {
        if (this.getTimer() != null) {
            LOGGER.debug("Closing ChannelPipelineFactory : {}", (Object)this.getClass().getName());
            this.getTimer().stop();
        }
    }

    public Map<String, ChannelHandler> getChannelHandlersMap() {
        HashMap<String, ChannelHandler> channelHandlersMap = new HashMap<String, ChannelHandler>();
        for (String handlerKey : this.getChannelHandlerBeanNamesMap().keySet()) {
            channelHandlersMap.put(handlerKey, (ChannelHandler)this.applicationContext.getBean(this.getChannelHandlerBeanNamesMap().get(handlerKey)));
        }
        return channelHandlersMap;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Registered Channel Handlers[");
        if (this.getIdleStateAwareChannelHandlerBean() != null) {
            buffer.append("idleStateCheck,");
            buffer.append("idleCheckHandler,");
        }
        for (String handlerKey : this.getChannelHandlerBeanNamesMap().keySet()) {
            buffer.append(String.valueOf(handlerKey) + ",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public long getChannelIdleTimeMillis() {
        return this.channelIdleTimeMillis;
    }

    public void setChannelIdleTimeMillis(long channelIdleTimeMillis) {
        this.channelIdleTimeMillis = channelIdleTimeMillis;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public String getIdleStateAwareChannelHandlerBean() {
        return this.idleStateAwareChannelHandlerBean;
    }

    public void setIdleStateAwareChannelHandlerBean(String idleStateAwareChannelHandlerBean) {
        this.idleStateAwareChannelHandlerBean = idleStateAwareChannelHandlerBean;
    }

    public Map<String, String> getChannelHandlerBeanNamesMap() {
        return this.channelHandlerBeanNamesMap;
    }

    public void setChannelHandlerBeanNamesMap(Map<String, String> channelHandlerBeanNamesMap) {
        this.channelHandlerBeanNamesMap = channelHandlerBeanNamesMap;
    }
}

