/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring.admin;

import com.flipkart.phantom.runtime.impl.server.AbstractNetworkServer;
import com.flipkart.phantom.runtime.impl.spring.ServiceProxyComponentContainer;
import com.flipkart.phantom.runtime.spi.spring.admin.SPConfigService;
import com.flipkart.phantom.task.impl.TaskContextFactory;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.core.PlatformException;

public class SPConfigServiceImpl<T extends AbstractHandler>
implements SPConfigService<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPConfigServiceImpl.class);
    public static final String PREV_HANDLER_FILE = "/spring-proxy-handler-prev.xml";
    private ServiceProxyComponentContainer<T> componentContainer;
    private Map<URI, List<T>> configURItoHandlerName = new HashMap<URI, List<T>>();
    private List<AbstractNetworkServer> deployedNetworkServers = new LinkedList<AbstractNetworkServer>();
    private List<AbstractHandlerRegistry<T>> registries = new ArrayList<AbstractHandlerRegistry<T>>();

    @Override
    public List<AbstractNetworkServer> getDeployedNetworkServers() {
        return this.deployedNetworkServers;
    }

    @Override
    public List<AbstractHandlerRegistry<T>> getDeployedRegistries() {
        return this.registries;
    }

    @Override
    public void addDeployedNetworkServer(AbstractNetworkServer server) {
        this.deployedNetworkServers.add(server);
    }

    @Override
    public void addHandlerRegistry(AbstractHandlerRegistry<T> registry) {
        this.registries.add(registry);
    }

    @Override
    public Resource getHandlerConfig(String handlerName) {
        for (URI configFile : this.configURItoHandlerName.keySet()) {
            for (AbstractHandler handler : this.configURItoHandlerName.get(configFile)) {
                if (!handler.getName().equals(handlerName)) continue;
                return new FileSystemResource(new File(configFile));
            }
        }
        return null;
    }

    @Override
    public void modifyHandlerConfig(String handlerName, ByteArrayResource modifiedHandlerConfigFile) {
        File oldHandlerFile = null;
        try {
            oldHandlerFile = this.getHandlerConfig(handlerName).getFile();
        }
        catch (IOException e1) {
            LOGGER.error("Handler Config File for handler: " + handlerName + " not found. Returning");
            throw new PlatformException("File not found for handler: " + handlerName, (Throwable)e1);
        }
        if (!oldHandlerFile.exists()) {
            LOGGER.error("Handler Config File: " + oldHandlerFile.getAbsolutePath() + " doesn't exist. Returning");
            throw new PlatformException("File not found: " + oldHandlerFile.getAbsolutePath());
        }
        if (!oldHandlerFile.canRead()) {
            LOGGER.error("No read permission for: " + oldHandlerFile.getAbsolutePath() + ". Returning");
            throw new PlatformException("Read permissions not found for file: " + oldHandlerFile.getAbsolutePath());
        }
        if (!oldHandlerFile.canWrite()) {
            LOGGER.error("No write permission for: " + oldHandlerFile.getAbsolutePath() + ". Write permissions are required to modify handler confib");
            throw new PlatformException("Required permissions not found for modifying file: " + oldHandlerFile.getAbsolutePath());
        }
        this.createPrevConfigFile(handlerName);
        try {
            this.upload(modifiedHandlerConfigFile.getByteArray(), oldHandlerFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.error("IOException while uploading file to path: " + oldHandlerFile.getAbsolutePath());
            this.restorePrevConfigFile(handlerName);
            throw new PlatformException((Throwable)e);
        }
        AbstractHandler handler = (AbstractHandler)this.configURItoHandlerName.get(oldHandlerFile.toURI()).get(0);
        try {
            this.componentContainer.reloadHandler(handler, this.getHandlerConfig(handlerName));
        }
        catch (Exception e) {
            this.restorePrevConfigFile(handlerName);
            this.componentContainer.loadComponent(this.getHandlerConfig(handlerName));
            throw new PlatformException((Throwable)e);
        }
        this.removePrevConfigFile(handlerName);
    }

    private void createPrevConfigFile(String handlerName) {
        File configFile = null;
        try {
            configFile = this.getHandlerConfig(handlerName).getFile();
        }
        catch (IOException e1) {
            LOGGER.error("Exception while getting handlerConfigFile", (Throwable)e1);
            throw new PlatformException("Exception while getting handlerConfigFile", (Throwable)e1);
        }
        File prevFile = new File(String.valueOf(configFile.getParent()) + "/" + PREV_HANDLER_FILE);
        if (configFile.exists()) {
            if (prevFile.exists()) {
                prevFile.delete();
            }
            configFile.renameTo(prevFile);
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("IOException while clearing config File", (Throwable)e);
                throw new PlatformException("IOException while clearing config File", (Throwable)e);
            }
            prevFile.deleteOnExit();
        }
    }

    private void removePrevConfigFile(String handlerName) {
        File configFile = null;
        try {
            configFile = this.getHandlerConfig(handlerName).getFile();
        }
        catch (IOException e) {
            LOGGER.error("IOException while getting HandlerConfigFile", (Throwable)e);
        }
        String prevFilePath = String.valueOf(configFile.getParent()) + PREV_HANDLER_FILE;
        File prevFile = new File(prevFilePath);
        if (prevFile.exists()) {
            prevFile.delete();
        }
    }

    private void restorePrevConfigFile(String handlerName) {
        File prevFile;
        File configFile = null;
        try {
            configFile = this.getHandlerConfig(handlerName).getFile();
        }
        catch (IOException e) {
            LOGGER.error("IOException while getting HandlerConfigFile", (Throwable)e);
        }
        if (configFile.exists()) {
            configFile.delete();
        }
        if ((prevFile = new File(String.valueOf(configFile.getParent()) + "/" + PREV_HANDLER_FILE)).exists()) {
            prevFile.renameTo(configFile);
        }
    }

    private void upload(byte[] fileContents, String destPath) throws IOException {
        File destFile = new File(destPath);
        if (destFile.exists()) {
            destFile.delete();
            destFile.createNewFile();
        }
        try {
            destFile.getParentFile().mkdirs();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create directory structure for uploading file");
            throw new PlatformException("Unable to create directory structure for uploading file");
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        fos.write(fileContents);
    }

    @Override
    public void addHandlerConfigPath(File taskHandlerFile, T handler) {
        if (this.configURItoHandlerName.get(taskHandlerFile.toURI()) == null) {
            this.configURItoHandlerName.put(taskHandlerFile.toURI(), new LinkedList());
        }
        this.configURItoHandlerName.get(taskHandlerFile.toURI()).add(handler);
    }

    @Override
    public void reinitHandler(String handlerName) throws Exception {
        for (AbstractHandlerRegistry<T> registry : this.registries) {
            if (registry.getHandler(handlerName) == null) continue;
            registry.reinitHandler(handlerName, TaskContextFactory.getTaskContext());
        }
    }

    @Override
    public void reloadHandler(String handlerName) throws Exception {
        File handlerFile = null;
        try {
            handlerFile = this.getHandlerConfig(handlerName).getFile();
        }
        catch (NullPointerException e) {
            LOGGER.error("Resource for handler: " + handlerName + " not found. Returning");
            throw new PlatformException("File not found for handler: " + handlerName, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Handler Config File for handler: " + handlerName + " not found. Returning");
            throw new PlatformException("File not found for handler: " + handlerName, (Throwable)e);
        }
        if (!handlerFile.exists()) {
            LOGGER.error("Handler Config File: " + handlerFile.getAbsolutePath() + " doesn't exist. Returning");
            throw new PlatformException("File not found: " + handlerFile.getAbsolutePath());
        }
        if (!handlerFile.canRead()) {
            LOGGER.error("No read permission for: " + handlerFile.getAbsolutePath() + ". Returning");
            throw new PlatformException("Read permissions not found for file: " + handlerFile.getAbsolutePath());
        }
        AbstractHandler handler = (AbstractHandler)this.configURItoHandlerName.get(handlerFile.toURI()).get(0);
        this.componentContainer.reloadHandler(handler, this.getHandlerConfig(handlerName));
    }

    @Override
    public List<AbstractHandler> getAllHandlers() {
        ArrayList<AbstractHandler> list = new ArrayList<AbstractHandler>();
        for (AbstractHandlerRegistry<T> registry : this.registries) {
            list.addAll(registry.getHandlers());
        }
        return list;
    }

    public ServiceProxyComponentContainer<T> getComponentContainer() {
        return this.componentContainer;
    }

    public void setComponentContainer(ServiceProxyComponentContainer<T> componentContainer) {
        this.componentContainer = componentContainer;
    }
}

