/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.hystrix.impl;

import com.flipkart.phantom.runtime.impl.hystrix.MetricsSnapshotReporter;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.util.HystrixRollingNumberEvent;
import java.util.HashMap;
import java.util.Map;

public class MetricsSnapshotReporterWithAggregation
implements Runnable,
MetricsSnapshotReporter {
    public Map<String, Map<String, Map<String, Long>>> lastDurationMetrics = new HashMap<String, Map<String, Map<String, Long>>>();
    private Map<String, Map<String, Map<String, Long>>> currentMetrics = new HashMap<String, Map<String, Map<String, Long>>>();
    private int frequency;
    private int counter = 0;

    public MetricsSnapshotReporterWithAggregation(int frequency) {
        this.frequency = frequency;
    }

    @Override
    public void run() {
        Map<String, Long> currStats;
        String commandName;
        ++this.counter;
        for (HystrixCommandMetrics commandMetrics : HystrixCommandMetrics.getInstances()) {
            commandName = String.valueOf(commandMetrics.getCommandGroup().name()) + "." + commandMetrics.getCommandKey().name();
            if (this.currentMetrics.get("HystrixCommand") == null) {
                this.currentMetrics.put("HystrixCommand", new HashMap());
            }
            if ((currStats = this.currentMetrics.get("HystrixCommand").get(commandName)) == null) {
                currStats = new HashMap<String, Long>();
            }
            HystrixCommandMetrics.HealthCounts healthCounts = commandMetrics.getHealthCounts();
            currStats.put("errorCount", healthCounts.getErrorCount() + this.zeroIfNull(currStats.get("errorCount")));
            currStats.put("requestCount", healthCounts.getTotalRequests() + this.zeroIfNull(currStats.get("requestCount")));
            currStats.put("rollingCountFailure", commandMetrics.getRollingCount(HystrixRollingNumberEvent.FAILURE) + this.zeroIfNull(currStats.get("rollingCountFailure")));
            currStats.put("rollingCountSemaphoreRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SEMAPHORE_REJECTED) + this.zeroIfNull(currStats.get("rollingCountSemaphoreRejected")));
            currStats.put("rollingCountShortCircuited", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SHORT_CIRCUITED) + this.zeroIfNull(currStats.get("rollingCountShortCircuited")));
            currStats.put("rollingCountSuccess", commandMetrics.getRollingCount(HystrixRollingNumberEvent.SUCCESS) + this.zeroIfNull(currStats.get("rollingCountSuccess")));
            currStats.put("rollingCountThreadPoolRejected", commandMetrics.getRollingCount(HystrixRollingNumberEvent.THREAD_POOL_REJECTED) + this.zeroIfNull(currStats.get("rollingCountThreadPoolRejected")));
            currStats.put("rollingCountTimeout", commandMetrics.getRollingCount(HystrixRollingNumberEvent.TIMEOUT) + this.zeroIfNull(currStats.get("rollingCountTimeout")));
            currStats.put("latencyTotal_mean", (long)commandMetrics.getTotalTimeMean() / (long)this.frequency + this.zeroIfNull(currStats.get("latencyTotal_mean")));
            currStats.put("0", (long)commandMetrics.getTotalTimePercentile(0.0) / (long)this.frequency + this.zeroIfNull(currStats.get("0")));
            currStats.put("25", (long)commandMetrics.getTotalTimePercentile(25.0) / (long)this.frequency + this.zeroIfNull(currStats.get("25")));
            currStats.put("50", (long)commandMetrics.getTotalTimePercentile(50.0) / (long)this.frequency + this.zeroIfNull(currStats.get("50")));
            currStats.put("75", (long)commandMetrics.getTotalTimePercentile(75.0) / (long)this.frequency + this.zeroIfNull(currStats.get("75")));
            currStats.put("90", (long)commandMetrics.getTotalTimePercentile(90.0) / (long)this.frequency + this.zeroIfNull(currStats.get("90")));
            currStats.put("95", (long)commandMetrics.getTotalTimePercentile(95.0) / (long)this.frequency + this.zeroIfNull(currStats.get("95")));
            currStats.put("99", (long)commandMetrics.getTotalTimePercentile(99.0) / (long)this.frequency + this.zeroIfNull(currStats.get("99")));
            currStats.put("99.5", (long)commandMetrics.getTotalTimePercentile(99.5) / (long)this.frequency + this.zeroIfNull(currStats.get("99.5")));
            currStats.put("100", (long)commandMetrics.getTotalTimePercentile(100.0) / (long)this.frequency + this.zeroIfNull(currStats.get("100")));
            this.currentMetrics.get("HystrixCommand").put(commandName, currStats);
        }
        for (HystrixCommandMetrics commandMetrics : HystrixThreadPoolMetrics.getInstances()) {
            commandName = commandMetrics.getThreadPoolKey().name();
            if (this.currentMetrics.get("HystrixThreadPool") == null) {
                this.currentMetrics.put("HystrixThreadPool", new HashMap());
            }
            if ((currStats = this.currentMetrics.get("HystrixThreadPool").get(commandName)) == null) {
                currStats = new HashMap<String, Long>();
            }
            currStats.put("currentActiveCount", (long)commandMetrics.getCurrentActiveCount().intValue() + this.zeroIfNull(currStats.get("currentActiveCount")));
            currStats.put("currentQueueSize", (long)commandMetrics.getCurrentQueueSize().intValue() + this.zeroIfNull(currStats.get("currentQueueSize")));
            this.currentMetrics.get("HystrixThreadPool").put(commandName, currStats);
        }
        if (this.counter == this.frequency) {
            this.lastDurationMetrics = new HashMap<String, Map<String, Map<String, Long>>>(this.currentMetrics);
            this.currentMetrics = new HashMap<String, Map<String, Map<String, Long>>>();
            this.counter = 0;
        }
    }

    @Override
    public Map<String, Map<String, Map<String, Long>>> getMetricsLastDuration() {
        return this.lastDurationMetrics;
    }

    private Long zeroIfNull(Long val) {
        return val == null ? 0L : val;
    }
}

