/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.spring.web;

import com.flipkart.phantom.runtime.impl.spring.ServiceProxyComponentContainer;
import java.io.File;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class WebContextLoaderListener
extends ContextLoaderListener {
    public static final String COMMON_WEB_CONFIG = "common-web-config.xml";
    private static final String FILE_PREFIX = "file:";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContextLoaderListener.class);

    protected ApplicationContext loadParentContext(ServletContext servletContext) {
        AbstractApplicationContext parentContext = ServiceProxyComponentContainer.getCommonProxyHandlerBeansContext();
        File[] commonWebConfigFiles = FileLocator.findFiles((String)COMMON_WEB_CONFIG);
        if (commonWebConfigFiles.length > 0) {
            if (commonWebConfigFiles.length == 1) {
                parentContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + commonWebConfigFiles[0].getAbsolutePath()}, (ApplicationContext)parentContext);
                LOGGER.info("Loaded Common Proxy Handler Config: " + commonWebConfigFiles[0]);
            } else {
                String errorMessage = "Found multiple common-web-config.xml, only one is allowed";
                LOGGER.error("Found multiple common-web-config.xml, only one is allowed");
                File[] fileArray = commonWebConfigFiles;
                int n = commonWebConfigFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File commonHandlerConfig = fileArray[n2];
                    LOGGER.error(commonHandlerConfig.getAbsolutePath());
                    ++n2;
                }
                throw new PlatformException("Found multiple common-web-config.xml, only one is allowed");
            }
        }
        return parentContext;
    }
}

