/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.phantom.task.spi.TaskResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

public class CommandInterpreter {
    public static final int MAX_COMMAND_INPUT = 20480;
    public static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char DEFAULT_DELIM = ' ';
    private static final char PARAM_VALUE_SEP = '=';
    private static final char[] ASCII_LOW = new char[]{'a', 'z'};
    private static final char[] ASCII_HIGH = new char[]{'A', 'Z'};
    private static final String SUCCESS = "SUCCESS";
    private static final String ERROR = "ERROR";
    private static final String NULL_STRING = "";
    private static final String DEFAULT_PARAM_VALUE = "true";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ProxyCommand readCommand(InputStream inputStream) throws Exception {
        return this.interpretCommand(inputStream, true);
    }

    public ProxyCommand readCommand(MessageEvent event) throws Exception {
        return this.interpretCommand((InputStream)new ChannelBufferInputStream((ChannelBuffer)event.getMessage()), true);
    }

    public ProxyCommand interpretCommand(ChannelBuffer buffer) throws Exception {
        return this.interpretCommand((InputStream)new ChannelBufferInputStream(buffer), false);
    }

    public void writeCommandExecutionResponse(ChannelHandlerContext ctx, ChannelEvent event, TaskResult result) throws Exception {
        ChannelBuffer writeBuffer = ChannelBuffers.dynamicBuffer();
        this.writeCommandExecutionResponse((OutputStream)new ChannelBufferOutputStream(writeBuffer), result);
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)event.getFuture(), (Object)writeBuffer);
    }

    public void writeCommandExecutionResponse(OutputStream outputStream, TaskResult result) throws Exception {
        if (result == null) {
            return;
        }
        String message = result.getMessage();
        boolean success = result.isSuccess();
        int resultDatalength = result.getLength();
        String metaContents = message == null ? (success ? SUCCESS : ERROR) : message;
        metaContents = metaContents + (resultDatalength == 0 ? Character.valueOf('\n') : " " + resultDatalength + NULL_STRING + '\n');
        outputStream.write(metaContents.getBytes());
        if (result.isDataArray()) {
            for (Object object : result.getDataArray()) {
                if (object == null) continue;
                if (object instanceof byte[]) {
                    outputStream.write((byte[])object);
                    continue;
                }
                OBJECT_MAPPER.writeValue(outputStream, object);
            }
        } else {
            Object data;
            byte[] metaData = result.getMetadata();
            if (metaData != null && metaData.length > 0) {
                outputStream.write(metaData);
            }
            if ((data = result.getData()) != null) {
                if (data instanceof byte[]) {
                    byte[] byteData = (byte[])data;
                    if (byteData.length > 0) {
                        outputStream.write(byteData);
                    }
                } else {
                    OBJECT_MAPPER.writeValue(outputStream, data);
                }
            }
        }
    }

    private ProxyCommand interpretCommand(InputStream inputStream, boolean isFramedTransport) throws Exception {
        ProxyCommand readCommand = null;
        byte[] readBytes = new byte[20480];
        int byteReadIndex = 0;
        int commandEndIndex = 0;
        int dataStartIndex = 0;
        int dataLength = 0;
        while (byteReadIndex < 20480) {
            int bytesRead = inputStream.read(readBytes, byteReadIndex, 20480 - byteReadIndex);
            if (bytesRead <= 0) {
                if (isFramedTransport) {
                    throw new IllegalArgumentException("Invalid read. Encountered end of stream before reading a single byte");
                }
                return new ProxyCommand(ReadFailure.INSUFFICIENT_DATA, "Invalid read. Encountered end of stream before reading a single byte");
            }
            for (int i = 0; i < bytesRead; ++i) {
                if (readBytes[byteReadIndex + i] != 10) continue;
                commandEndIndex = byteReadIndex + i;
                break;
            }
            if (bytesRead > 0) {
                byteReadIndex += bytesRead;
            }
            if (commandEndIndex <= 0 && bytesRead > 0) continue;
            break;
        }
        if (commandEndIndex == 0) {
            if (byteReadIndex < 20480) {
                if (isFramedTransport) {
                    throw new IllegalArgumentException("Stream ended before encountering a \\n: " + new String(readBytes, 0, byteReadIndex));
                }
                return new ProxyCommand(ReadFailure.INSUFFICIENT_DATA, "Stream ended before encountering a \\n: " + new String(readBytes, 0, byteReadIndex));
            }
            throw new IllegalArgumentException("Maximum command line size allowed: 20480 Command : " + new String(readBytes, 0, byteReadIndex));
        }
        dataStartIndex = commandEndIndex + 1;
        if (readBytes[commandEndIndex - 1] == 13) {
            --commandEndIndex;
        }
        byte delimiter = 32;
        int fragmentStart = 0;
        if (!(readBytes[0] >= ASCII_LOW[0] && readBytes[0] <= ASCII_LOW[1] || readBytes[0] >= ASCII_HIGH[0] && readBytes[0] <= ASCII_HIGH[1])) {
            delimiter = readBytes[0];
            fragmentStart = 1;
        }
        int fragmentIndex = this.getNextCommandFragmentPosition(readBytes, fragmentStart, commandEndIndex, delimiter);
        readCommand = new ProxyCommand(new String(readBytes, fragmentStart, fragmentIndex - fragmentStart));
        HashMap<String, String> commandParams = new HashMap<String, String>();
        while (fragmentIndex < commandEndIndex) {
            while (fragmentIndex < commandEndIndex && readBytes[fragmentIndex] == delimiter) {
                ++fragmentIndex;
            }
            if (fragmentIndex == commandEndIndex) break;
            if (Character.isDigit((char)readBytes[fragmentIndex])) {
                try {
                    dataLength = Integer.parseInt(new String(readBytes, fragmentIndex, commandEndIndex - fragmentIndex));
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid syntax in command: " + new String(readBytes), e);
                }
            }
            fragmentStart = fragmentIndex;
            fragmentIndex = this.getNextCommandFragmentPosition(readBytes, fragmentIndex + 1, commandEndIndex, delimiter);
            int paramValueSepIndex = 0;
            for (int i = fragmentStart; i < fragmentIndex; ++i) {
                if (readBytes[i] != 61) continue;
                paramValueSepIndex = i;
                break;
            }
            if (paramValueSepIndex > 0) {
                commandParams.put(new String(readBytes, fragmentStart, paramValueSepIndex - fragmentStart), new String(readBytes, paramValueSepIndex + 1, fragmentIndex - paramValueSepIndex - 1));
            } else {
                commandParams.put(new String(readBytes, fragmentStart, fragmentIndex - fragmentStart), DEFAULT_PARAM_VALUE);
            }
            readCommand.setCommandParams(commandParams);
        }
        if (dataLength > 0) {
            byte[] commandData = new byte[dataLength];
            int dataByteReadIndex = byteReadIndex - dataStartIndex;
            if (dataStartIndex < byteReadIndex) {
                System.arraycopy(readBytes, dataStartIndex, commandData, 0, dataByteReadIndex);
            }
            while (dataByteReadIndex < dataLength) {
                if (inputStream.available() < dataLength - dataByteReadIndex && !isFramedTransport) {
                    return new ProxyCommand(ReadFailure.INSUFFICIENT_DATA, "Stream ended before all data was read. Length of data bytes needed : " + (dataLength - dataByteReadIndex));
                }
                int actualBytesRead = inputStream.read(commandData, dataByteReadIndex, dataLength - dataByteReadIndex);
                if (actualBytesRead <= 0) {
                    throw new IllegalArgumentException("Insufficient bytes read for command : " + readCommand.getCommand() + ". Expected : " + (dataLength - dataByteReadIndex) + " but read : " + actualBytesRead);
                }
                dataByteReadIndex += actualBytesRead;
            }
            readCommand.setCommandData(commandData);
        }
        return readCommand;
    }

    private int getNextCommandFragmentPosition(byte[] arr, int fragmentStart, int lastPos, byte delim) {
        while (fragmentStart < lastPos) {
            if (arr[fragmentStart] == delim) {
                return fragmentStart;
            }
            ++fragmentStart;
        }
        return fragmentStart;
    }

    public class ProxyCommand {
        private String command;
        private ReadFailure readFailure;
        private String readFailureDescription;
        private Map<String, String> commandParams = new HashMap<String, String>();
        private byte[] commandData;

        public ProxyCommand(String command) {
            this.command = command;
        }

        public ProxyCommand(ReadFailure readFailure, String readFailureDescription) {
            this.readFailure = readFailure;
            this.readFailureDescription = readFailureDescription;
        }

        public String toString() {
            try {
                return String.format("ProxyCommand[Command = %s, Read Error = %s, Params = %s]", this.getCommand(), this.getReadFailureDescription(), this.commandParams != null ? OBJECT_MAPPER.writeValueAsString(this.getCommandParams()) : CommandInterpreter.NULL_STRING);
            }
            catch (Exception e) {
                return "ProxyCommand[Command = " + this.command + ". Read Error = " + this.readFailureDescription + "]";
            }
        }

        public String getCommand() {
            return this.command;
        }

        public ReadFailure getReadFailure() {
            return this.readFailure;
        }

        public String getReadFailureDescription() {
            return this.readFailureDescription;
        }

        public Map<String, String> getCommandParams() {
            return this.commandParams;
        }

        public void setCommandParams(Map<String, String> commandParams) {
            this.commandParams = commandParams;
        }

        public byte[] getCommandData() {
            return this.commandData;
        }

        public void setCommandData(byte[] commandData) {
            this.commandData = commandData;
        }
    }

    public static enum ReadFailure {
        INSUFFICIENT_DATA;

    }
}

