/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.jetty;

import java.io.File;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.beans.factory.FactoryBean;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class JettyWebAppContextFactory
implements FactoryBean<WebAppContext> {
    public static final int DEFAULT_MAX_FORM_SIZE = 2000000;
    private String contextName;
    private String contextPath;
    private int maxFormContentSize = 2000000;

    public Class<WebAppContext> getObjectType() {
        return WebAppContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public WebAppContext getObject() throws Exception {
        File[] files;
        String path = null;
        for (File file : files = FileLocator.findDirectories((String)this.getContextPath(), null)) {
            String fileToString = file.toString();
            if (fileToString.contains(".jar!") && fileToString.startsWith("file:/")) {
                if (!(fileToString = fileToString.replace("file:/", "jar:file:/")).contains("runtime-")) continue;
                path = fileToString;
                break;
            }
            if (!fileToString.contains("runtime")) continue;
            path = fileToString;
            break;
        }
        if (path.endsWith("WEB-INF")) {
            path = path.replace("WEB-INF", "");
        }
        WebAppContext webAppContext = new WebAppContext(path, this.getContextName());
        webAppContext.setMaxFormContentSize(this.getMaxFormContentSize());
        return webAppContext;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getMaxFormContentSize() {
        return this.maxFormContentSize;
    }

    public void setMaxFormContentSize(int maxFormContentSize) {
        this.maxFormContentSize = maxFormContentSize;
    }
}

