/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleChannelDisconnectHandler
extends IdleStateAwareChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleChannelDisconnectHandler.class);

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) throws Exception {
        if (event.getState() == IdleState.ALL_IDLE) {
            LOGGER.warn("Channel {} is idle. Disconnect initiated", (Object)event.getChannel());
            event.getChannel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        StringWriter errors = new StringWriter();
        event.getCause().printStackTrace(new PrintWriter(errors));
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated. Stack Trace: " + errors, (Object)event, (Object)event.getCause());
        event.getChannel().close();
    }
}

