/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.command;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.handler.command.CommandInterpreter;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.ServerRequestInterceptor;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskRequestWrapper;
import com.flipkart.phantom.task.spi.TaskResult;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CommandProcessingChannelHandler
extends SimpleChannelUpstreamHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandProcessingChannelHandler.class);
    public static final String POOL_PARAM = "pool";
    private static final String DEFAULT_SERVICE_NAME = "Command Proxy";
    private static final String COMMAND_HANDLER = "COMMAND_HANDLER";
    private static final TraceFilter NO_TRACING = new FixedSampleRateTraceFilter(-1);
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static String hostName = "localhost";
    private String serviceName = "Command Proxy";
    private int hostPort;
    private ChannelGroup defaultChannelGroup;
    private ExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> repository;
    private ServiceProxyEventProducer eventProducer;
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelBound(ctx, event);
        if (InetSocketAddress.class.isAssignableFrom(event.getValue().getClass())) {
            this.hostPort = ((InetSocketAddress)event.getValue()).getPort();
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        long receiveTime = System.currentTimeMillis();
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            CommandInterpreter commandInterpreter = new CommandInterpreter();
            CommandInterpreter.ProxyCommand readCommand = commandInterpreter.readCommand((MessageEvent)event);
            LOGGER.debug("Read Command : " + readCommand);
            String pool = (String)readCommand.getCommandParams().get(POOL_PARAM);
            TaskRequestWrapper taskRequestWrapper = new TaskRequestWrapper();
            taskRequestWrapper.setCommandName(readCommand.getCommand());
            taskRequestWrapper.setData((Object)readCommand.getCommandData());
            taskRequestWrapper.setParams(readCommand.getCommandParams());
            taskRequestWrapper.setServiceName(Optional.of((Object)this.serviceName));
            ServerRequestInterceptor<TaskRequestWrapper, TaskResult> serverRequestInterceptor = this.initializeServerTracing(taskRequestWrapper);
            TaskHandlerExecutor executor = pool != null ? (TaskHandlerExecutor)this.repository.getExecutor(readCommand.getCommand(), pool, (RequestWrapper)taskRequestWrapper) : (TaskHandlerExecutor)this.repository.getExecutor(readCommand.getCommand(), readCommand.getCommand(), (RequestWrapper)taskRequestWrapper);
            taskRequestWrapper.setServiceName(executor.getServiceName());
            TaskResult result = null;
            Optional transportError = Optional.absent();
            try {
                if (executor.getCallInvocationType() == 0) {
                    result = (TaskResult)executor.execute();
                } else {
                    executor.queue();
                    result = new TaskResult(true, "The command dispatched for async execution");
                }
                LOGGER.debug("The output is: " + result);
                commandInterpreter.writeCommandExecutionResponse(ctx, event, result);
            }
            catch (Exception e) {
                try {
                    RuntimeException runtimeException = new RuntimeException("Error in executing command : " + readCommand, e);
                    transportError = Optional.of((Object)runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    serverRequestInterceptor.process(result, transportError);
                    if (this.eventProducer != null) {
                        String requestID = (String)readCommand.getCommandParams().get("requestID");
                        ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                        eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                        this.eventProducer.publishEvent(eventBuilder.build());
                    } else {
                        LOGGER.debug("eventProducer not set, not publishing event");
                    }
                    throw throwable;
                }
            }
            serverRequestInterceptor.process((Object)result, transportError);
            if (this.eventProducer != null) {
                String requestID = (String)readCommand.getCommandParams().get("requestID");
                ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(readCommand.getCommand(), COMMAND_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData((Executor)executor).withEventSource(executor.getClass().getName());
                eventBuilder.withRequestId(requestID).withRequestReceiveTime(receiveTime);
                this.eventProducer.publishEvent(eventBuilder.build());
            } else {
                LOGGER.debug("eventProducer not set, not publishing event");
            }
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
    }

    private ServerRequestInterceptor<TaskRequestWrapper, TaskResult> initializeServerTracing(TaskRequestWrapper executorRequest) {
        ServerRequestInterceptor serverRequestInterceptor = new ServerRequestInterceptor();
        List<TraceFilter> traceFilters = Arrays.asList(this.traceFilter);
        ServerTracer serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, traceFilters);
        serverRequestInterceptor.setEndPointSubmitter(Brave.getEndPointSubmitter());
        serverRequestInterceptor.setServerTracer(serverTracer);
        serverRequestInterceptor.setServiceHost(hostName);
        serverRequestInterceptor.setServicePort(this.hostPort);
        serverRequestInterceptor.setServiceName(this.serviceName);
        serverRequestInterceptor.process((RequestWrapper)executorRequest);
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        RequestContext serverRequestContext = new RequestContext();
        serverRequestContext.setCurrentServerSpan(serverSpan);
        executorRequest.setRequestContext(Optional.of((Object)serverRequestContext));
        return serverRequestInterceptor;
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public ExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository<TaskRequestWrapper, TaskResult, TaskHandler> repository) {
        this.repository = repository;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void setTraceFilter(TraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve local host name. Will use default host name : localhost");
        }
    }
}

