/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.http.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionPool {
    public static final boolean FORWARD_HEADERS = false;
    public static final Set<String> REMOVE_HEADERS = new HashSet<String>();
    private static Logger logger;
    private DefaultHttpClient client;
    private String host = "localhost";
    private Integer port = 80;
    private Boolean secure = false;
    private int connectionTimeout = 1000;
    private int operationTimeout = 1000;
    private int maxConnections = 20;
    private int requestQueueSize = 0;
    private Semaphore processQueue;
    private Map<String, String> headers;
    private boolean forwardHeaders = false;

    static {
        REMOVE_HEADERS.add("Content-Length");
        logger = LoggerFactory.getLogger(HttpConnectionPool.class);
    }

    public void initConnectionPool() {
        this.processQueue = new Semaphore(this.requestQueueSize + this.maxConnections);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", this.port.intValue(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", this.port.intValue(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setMaxTotal(this.maxConnections);
        cm.setDefaultMaxPerRoute(this.maxConnections);
        HttpHost httpHost = new HttpHost(this.host, this.port.intValue());
        cm.setMaxPerRoute(new HttpRoute(httpHost), this.maxConnections);
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.operationTimeout);
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)httpParams);
    }

    public HttpResponse execute(HttpRequestBase request, List<Map.Entry<String, String>> headers) throws Exception {
        this.setRequestHeaders(request, headers);
        logger.debug("Sending request: " + request.getURI());
        if (this.processQueue.tryAcquire()) {
            HttpResponse response;
            try {
                response = this.client.execute((HttpUriRequest)request);
            }
            catch (Exception e) {
                this.processQueue.release();
                throw e;
            }
            this.processQueue.release();
            return response;
        }
        throw new Exception("Process queue full!");
    }

    protected void setRequestHeaders(HttpRequestBase request, List<Map.Entry<String, String>> requestHeaders) {
        if (this.headers != null && this.headers.isEmpty()) {
            for (String string : this.headers.keySet()) {
                request.addHeader(string, this.headers.get(string));
            }
        }
        if (this.isForwardHeaders()) {
            if (requestHeaders != null && !requestHeaders.isEmpty()) {
                for (Map.Entry entry : requestHeaders) {
                    if (REMOVE_HEADERS.contains(entry.getKey())) continue;
                    request.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            request.setHeader("Host", String.valueOf(this.getHost()) + ":" + this.getPort());
        }
    }

    public String constructUrl(String uri) {
        return "http" + (this.secure != false ? "s" : "") + "://" + this.host + ":" + this.port + uri;
    }

    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public void setRequestQueueSize(int requestQueueSize) {
        this.requestQueueSize = requestQueueSize;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean isForwardHeaders() {
        return this.forwardHeaders;
    }

    public void setForwardHeaders(boolean forwardHeaders) {
        this.forwardHeaders = forwardHeaders;
    }
}

