/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.http.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.http.impl.HttpProxy;
import com.flipkart.phantom.http.impl.HttpRequestWrapper;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import org.apache.http.HttpResponse;

public class HttpProxyExecutor
extends HystrixCommand<HttpResponse>
implements Executor {
    HttpRequestWrapper httpRequestWrapper;
    private HttpProxy proxy;
    private TaskContext taskContext;
    protected ServiceProxyEvent.Builder eventBuilder;
    private static final String HTTP_HANDLER = "HTTP_HANDLER";

    public HttpProxyExecutor(HttpProxy proxy, TaskContext taskContext, RequestWrapper requestWrapper) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)proxy.getGroupKey())).andCommandKey(HystrixCommandKey.Factory.asKey((String)proxy.getCommandKey())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)proxy.getThreadPoolKey())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(proxy.getThreadPoolSize())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(proxy.getPool().getOperationTimeout())));
        this.proxy = proxy;
        this.taskContext = taskContext;
        this.httpRequestWrapper = (HttpRequestWrapper)requestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(this.httpRequestWrapper.getUri(), HTTP_HANDLER);
    }

    protected HttpResponse run() throws Exception {
        this.eventBuilder.withRequestExecutionStartTime(System.currentTimeMillis());
        return this.proxy.doRequest(this.httpRequestWrapper);
    }

    protected HttpResponse getFallback() {
        return this.proxy.fallbackRequest(this.httpRequestWrapper);
    }

    public ServiceProxyEvent.Builder getEventBuilder() {
        return this.eventBuilder;
    }
}

