/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.http.impl;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.http.impl.HttpProxy;
import com.flipkart.phantom.http.impl.HttpRequestWrapper;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.interceptor.RequestInterceptor;
import com.flipkart.phantom.task.spi.interceptor.ResponseInterceptor;
import com.github.kristofa.brave.Brave;
import com.google.common.base.Optional;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.HttpClientUtils;

public class HttpProxyExecutor
extends HystrixCommand<HttpResponse>
implements Executor<HttpRequestWrapper, HttpResponse> {
    private static final String HTTP_HANDLER = "HTTP_HANDLER";
    private HttpRequestWrapper httpRequestWrapper;
    private HttpProxy proxy;
    protected ServiceProxyEvent.Builder eventBuilder;
    private List<RequestInterceptor<HttpRequestWrapper>> requestInterceptors = new LinkedList<RequestInterceptor<HttpRequestWrapper>>();
    private List<ResponseInterceptor<HttpResponse>> responseInterceptors = new LinkedList<ResponseInterceptor<HttpResponse>>();

    public HttpProxyExecutor(HttpProxy proxy, TaskContext taskContext, HttpRequestWrapper httpRequestWrapper) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)proxy.getGroupKey())).andCommandKey(HystrixCommandKey.Factory.asKey((String)proxy.getCommandKey())).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)proxy.getThreadPoolKey())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(proxy.getThreadPoolSize())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationThreadTimeoutInMilliseconds(proxy.getPool().getOperationTimeout())));
        this.proxy = proxy;
        this.httpRequestWrapper = httpRequestWrapper;
        this.eventBuilder = new ServiceProxyEvent.Builder(this.httpRequestWrapper.getUri(), HTTP_HANDLER);
    }

    /*
     * Unable to fully structure code
     */
    protected HttpResponse run() throws Exception {
        this.eventBuilder.withRequestExecutionStartTime(System.currentTimeMillis());
        if (this.httpRequestWrapper.getRequestContext().isPresent() && ((RequestContext)this.httpRequestWrapper.getRequestContext().get()).getCurrentServerSpan() != null) {
            Brave.getServerSpanThreadBinder().setCurrentSpan(((RequestContext)this.httpRequestWrapper.getRequestContext().get()).getCurrentServerSpan());
        }
        for (RequestInterceptor<HttpRequestWrapper> requestInterceptor : this.requestInterceptors) {
            requestInterceptor.process((RequestWrapper)this.httpRequestWrapper);
        }
        transportException = Optional.absent();
        response = null;
        try {
            try {
                response = this.proxy.doRequest(this.httpRequestWrapper);
            }
            catch (RuntimeException e) {
                transportException = Optional.of((Object)e);
                throw e;
            }
        }
        finally {
            if (this.isResponseTimedOut() && response != null) {
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
            ** for (responseInterceptor : this.responseInterceptors)
        }
lbl-1000:
        // 1 sources

        {
            responseInterceptor.process((Object)response, transportException);
            continue;
        }
lbl23:
        // 1 sources

        return response;
    }

    public Optional<String> getServiceName() {
        return Optional.of((Object)this.proxy.getName());
    }

    public HttpRequestWrapper getRequestWrapper() {
        return this.httpRequestWrapper;
    }

    public void addRequestInterceptor(RequestInterceptor<HttpRequestWrapper> requestInterceptor) {
        this.requestInterceptors.add(requestInterceptor);
    }

    public void addResponseInterceptor(ResponseInterceptor<HttpResponse> responseInterceptor) {
        this.responseInterceptors.add(responseInterceptor);
    }

    protected HttpResponse getFallback() {
        return this.proxy.fallbackRequest(this.httpRequestWrapper);
    }

    public ServiceProxyEvent.Builder getEventBuilder() {
        return this.eventBuilder;
    }
}

