/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.http.impl;

import com.flipkart.phantom.http.impl.HttpConnectionPool;
import com.flipkart.phantom.http.impl.HttpRequestWrapper;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;

public abstract class HttpProxy
extends AbstractHandler {
    public static final int DEFAULT_THREAD_POOL_SIZE = 500;
    private String name;
    private HttpConnectionPool pool;
    private int threadPoolSize = 500;

    public void init(TaskContext context) throws Exception {
        if (this.pool == null) {
            throw new AssertionError((Object)"HttpConnectionPool object 'pool' must be given");
        }
        this.pool.initConnectionPool();
    }

    public void shutdown(TaskContext context) throws Exception {
        this.pool.shutdown();
    }

    public String getHost() {
        return this.getPool().getHost();
    }

    public int getPort() {
        return this.getPool().getPort();
    }

    public HttpResponse doRequest(HttpRequestWrapper httpRequestWrapper) throws Exception {
        return this.pool.execute(this.createRequest(httpRequestWrapper.getMethod(), httpRequestWrapper.getUri(), httpRequestWrapper.getData()), (List)httpRequestWrapper.getHeaders().get());
    }

    private HttpRequestBase createRequest(String method, String uri, byte[] data) throws Exception {
        if ("GET".equals(method)) {
            HttpGet r = new HttpGet(this.pool.constructUrl(uri));
            return r;
        }
        if ("PUT".equals(method)) {
            HttpPut r = new HttpPut(this.pool.constructUrl(uri));
            r.setEntity((HttpEntity)new ByteArrayEntity(data));
            return r;
        }
        if ("POST".equals(method)) {
            HttpPost r = new HttpPost(this.pool.constructUrl(uri));
            r.setEntity((HttpEntity)new ByteArrayEntity(data));
            return r;
        }
        if ("DELETE".equals(method)) {
            HttpDelete r = new HttpDelete(this.pool.constructUrl(uri));
            return r;
        }
        return null;
    }

    public abstract HttpResponse fallbackRequest(HttpRequestWrapper var1, Map<String, Object> var2);

    public abstract String getGroupKey();

    public abstract String getCommandKey();

    public abstract String getThreadPoolKey();

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getDetails() {
        if (this.pool != null) {
            String details = "Endpoint: ";
            details = details + (this.pool.getSecure() != false ? "https://" : "http://") + this.pool.getHost() + ":" + this.pool.getPort() + "\n";
            details = details + "Connection Timeout: " + this.pool.getConnectionTimeout() + "ms\n";
            details = details + "Operation Timeout: " + this.pool.getOperationTimeout() + "ms\n";
            details = details + "Max Connections: " + this.pool.getMaxConnections() + "\n";
            details = details + "Request Queue Size: " + this.pool.getRequestQueueSize() + "\n";
            return details;
        }
        return "No endpoint configured";
    }

    public String getType() {
        return "HttpProxy";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public HttpConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(HttpConnectionPool pool) {
        this.pool = pool;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }
}

