/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServiceClient
extends TServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServiceClient.class);
    private TProtocol clientProtocol;

    public ProxyServiceClient(TProtocol clientProtocol, TProtocol iprot, TProtocol oprot) {
        super(iprot, oprot);
        this.clientProtocol = clientProtocol;
    }

    public void sendBase(String methodName, TBase args, int sequenceId) throws TException {
        this.seqid_ = sequenceId;
        this.oprot_.writeMessageBegin(new TMessage(methodName, 1, this.seqid_));
        args.write(this.oprot_);
        this.oprot_.writeMessageEnd();
        this.oprot_.getTransport().flush();
    }

    public void receiveBase(TBase result, String methodName) throws TException {
        TMessage msg = this.iprot_.readMessageBegin();
        if (msg.type == 3) {
            TApplicationException x = TApplicationException.read((TProtocol)this.iprot_);
            this.iprot_.readMessageEnd();
            throw x;
        }
        if (msg.seqid != this.seqid_) {
            throw new TApplicationException(4, methodName + " failed: out of sequence response");
        }
        result.read(this.iprot_);
        this.iprot_.readMessageEnd();
        this.clientProtocol.writeMessageBegin(msg);
        result.write(this.clientProtocol);
        this.clientProtocol.writeMessageEnd();
        this.clientProtocol.getTransport().flush();
        LOGGER.debug("Relayed thrift response to client. Seq Id : " + msg.seqid + ", Method : " + msg.name + ", value : " + result);
    }
}

