/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl.registry;

import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ThriftProxyRegistry
implements AbstractHandlerRegistry {
    private static final Logger LOGGER = LogFactory.getLogger(ThriftProxyRegistry.class);
    private Map<String, ThriftProxy> proxies = new HashMap<String, ThriftProxy>();

    public AbstractHandlerRegistry.InitedHandlerInfo[] init(List<HandlerConfigInfo> handlerConfigInfoList, TaskContext taskContext) throws Exception {
        LinkedList<AbstractHandlerRegistry.InitedHandlerInfo> initedHanlderInfos = new LinkedList<AbstractHandlerRegistry.InitedHandlerInfo>();
        for (HandlerConfigInfo handlerConfigInfo : handlerConfigInfoList) {
            String[] proxyBeanIds;
            String[] stringArray = proxyBeanIds = handlerConfigInfo.getProxyHandlerContext().getBeanNamesForType(ThriftProxy.class);
            int n = proxyBeanIds.length;
            int n2 = 0;
            while (n2 < n) {
                String proxyBeanId = stringArray[n2];
                ThriftProxy proxy = (ThriftProxy)((Object)handlerConfigInfo.getProxyHandlerContext().getBean(proxyBeanId));
                try {
                    LOGGER.info("Initializing ThriftProxy: " + proxy.getName());
                    proxy.init(taskContext);
                    proxy.activate();
                    initedHanlderInfos.add(new AbstractHandlerRegistry.InitedHandlerInfo((AbstractHandler)proxy, handlerConfigInfo));
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing ThriftProxy {}. Error is: " + e.getMessage(), (Object)proxy.getName(), (Object)e);
                    throw new PlatformException("Error initializing ThriftProxy: " + proxy.getName(), (Throwable)e);
                }
                this.proxies.put(proxy.getName(), proxy);
                ++n2;
            }
        }
        return initedHanlderInfos.toArray(new AbstractHandlerRegistry.InitedHandlerInfo[0]);
    }

    public void reinitHandler(String name, TaskContext taskContext) throws Exception {
        ThriftProxy proxy = this.proxies.get(name);
        if (proxy != null) {
            try {
                proxy.deactivate();
                proxy.shutdown(taskContext);
                proxy.init(taskContext);
                proxy.activate();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing ThriftProxy {}. Error is: " + e.getMessage(), (Object)name, (Object)e);
                throw new PlatformException("Error reinitializing ThriftProxy: " + name, (Throwable)e);
            }
        }
    }

    public void shutdown(TaskContext taskContext) throws Exception {
        for (String name : this.proxies.keySet()) {
            try {
                LOGGER.info("Shutting down ThriftProxy: " + name);
                this.proxies.get(name).shutdown(taskContext);
                this.proxies.get(name).deactivate();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown ThriftProxy: " + name, (Throwable)e);
            }
        }
    }

    public List<AbstractHandler> getHandlers() {
        return new ArrayList<AbstractHandler>(this.proxies.values());
    }

    public AbstractHandler getHandler(String name) {
        return this.proxies.get(name);
    }

    public void unregisterTaskHandler(AbstractHandler taskHandler) {
        this.proxies.remove(taskHandler.getName());
    }

    public Map<String, ThriftProxy> getProxies() {
        return this.proxies;
    }

    public void setProxies(Map<String, ThriftProxy> proxies) {
        this.proxies = proxies;
    }
}

