/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import com.flipkart.phantom.task.impl.interceptor.ClientRequestInterceptor;
import com.flipkart.phantom.task.impl.repository.AbstractExecutorRepository;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.thrift.impl.HystrixThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftProxyExecutor;
import com.flipkart.phantom.thrift.impl.ThriftRequestWrapper;
import com.flipkart.phantom.thrift.impl.interceptor.ThriftClientResponseInterceptor;
import org.apache.thrift.transport.TTransport;

public class ThriftProxyExecutorRepository
extends AbstractExecutorRepository<ThriftRequestWrapper, TTransport, ThriftProxy> {
    public Executor<ThriftRequestWrapper, TTransport> getExecutor(String commandName, String proxyName, ThriftRequestWrapper requestWrapper) {
        HystrixThriftProxy proxy = (HystrixThriftProxy)this.registry.getHandler(proxyName);
        if (proxy.isActive()) {
            ThriftProxyExecutor executor = new ThriftProxyExecutor(proxy, this.taskContext, commandName, requestWrapper);
            return this.wrapExecutorWithInterceptors(executor, proxy);
        }
        throw new RuntimeException("The ThriftProxy is not active.");
    }

    private Executor<ThriftRequestWrapper, TTransport> wrapExecutorWithInterceptors(Executor<ThriftRequestWrapper, TTransport> executor, HystrixThriftProxy proxy) {
        ClientRequestInterceptor tracingRequestInterceptor = new ClientRequestInterceptor();
        ThriftClientResponseInterceptor tracingResponseInterceptor = new ThriftClientResponseInterceptor();
        return this.wrapExecutorWithInterceptors(executor, proxy, tracingRequestInterceptor, tracingResponseInterceptor);
    }
}

