/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl;

import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.transport.TTransport;
import org.springframework.util.StringUtils;

public abstract class HystrixThriftProxy
extends ThriftProxy {
    private static final int DEFAULT_EXECUTOR_TIMEOUT = 1000;
    private int proxyExecutorTimeout = 1000;
    private Integer proxyThreadPoolSize;
    protected Map<String, Integer> executorTimeouts = new HashMap<String, Integer>();

    public abstract void fallbackThriftRequest(TTransport var1, TaskContext var2);

    public String getGroupName() {
        return super.getName();
    }

    public String getThreadPoolName() {
        return super.getName();
    }

    public HystrixCommandProperties.Setter getHystrixProperties() {
        return null;
    }

    public String getDetails() {
        String details = "Service Class: " + this.getThriftServiceClass() + "\n";
        details = String.valueOf(details) + "Endpoint: " + this.getThriftServer() + ":" + this.getThriftPort() + "\n";
        details = String.valueOf(details) + "Timeout: " + this.getThriftTimeoutMillis() + "ms\n";
        details = String.valueOf(details) + "Executor Timeout: " + this.getProxyExecutorTimeout() + "ms\n";
        details = String.valueOf(details) + "Methods: " + StringUtils.collectionToDelimitedString(this.processMap.keySet(), (String)", ") + "\n";
        return details;
    }

    public int getExecutorTimeout(String commandName) {
        Integer timeout = this.getExecutorTimeouts().get(commandName);
        if (timeout != null) {
            return timeout;
        }
        if (this.getProxyExecutorTimeout() != 1000) {
            return this.getProxyExecutorTimeout();
        }
        return 1000;
    }

    public Map<String, Integer> getExecutorTimeouts() {
        return this.executorTimeouts;
    }

    public void setExecutorTimeouts(Map<String, Integer> executorTimeouts) {
        this.executorTimeouts = executorTimeouts;
    }

    public int getProxyExecutorTimeout() {
        return this.proxyExecutorTimeout;
    }

    public void setProxyExecutorTimeout(int proxyExecutorTimeout) {
        this.proxyExecutorTimeout = proxyExecutorTimeout;
    }

    public Integer getProxyThreadPoolSize() {
        return this.proxyThreadPoolSize;
    }

    public void setProxyThreadPoolSize(Integer proxyThreadPoolSize) {
        this.proxyThreadPoolSize = proxyThreadPoolSize;
    }
}

