/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.thrift.impl.proxy;

import com.flipkart.phantom.thrift.impl.ThriftProxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.pool.PoolableObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketObjectFactory
implements PoolableObjectFactory<Socket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketObjectFactory.class);
    private ThriftProxy thriftProxy;

    public SocketObjectFactory(ThriftProxy thriftProxy) {
        this.setThriftProxy(thriftProxy);
    }

    public Socket makeObject() throws Exception {
        Socket socket = new Socket();
        socket.setSoTimeout(this.getThriftProxy().getThriftTimeoutMillis());
        socket.connect(new InetSocketAddress(this.getThriftProxy().getThriftServer(), this.getThriftProxy().getThriftPort()));
        LOGGER.info("Creating a new socket for server : {} at port : {}", (Object)this.getThriftProxy().getThriftServer(), (Object)this.getThriftProxy().getThriftPort());
        return socket;
    }

    public void destroyObject(Socket socket) throws Exception {
        LOGGER.info("Closing a socket for server : {} at port : {}", (Object)this.getThriftProxy().getThriftServer(), (Object)this.getThriftProxy().getThriftPort());
        socket.close();
    }

    public boolean validateObject(Socket socket) {
        if (socket.isClosed()) {
            return false;
        }
        try {
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            return true;
        }
        catch (Exception e) {
            LOGGER.info("Socket is not valid for server : {} at port : {}", (Object)this.getThriftProxy().getThriftServer(), (Object)this.getThriftProxy().getThriftPort());
            return false;
        }
    }

    public void activateObject(Socket socket) throws Exception {
    }

    public void passivateObject(Socket socket) throws Exception {
    }

    public ThriftProxy getThriftProxy() {
        return this.thriftProxy;
    }

    public void setThriftProxy(ThriftProxy thriftProxy) {
        this.thriftProxy = thriftProxy;
    }
}

