/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import java.util.Arrays;
import java.util.List;

public class TaskResult {
    private static final int DEFAULT_LENGTH = 0;
    private final boolean success;
    private final String message;
    private final Object data;
    private final List<Object> dataList;
    private final int length;
    private boolean profilingDone = false;

    public TaskResult(boolean success, String message) {
        this(success, message, null);
    }

    public TaskResult(boolean success, String message, Object data) {
        byte[] dataBytes;
        this.success = success;
        this.message = message;
        this.data = data;
        this.dataList = null;
        this.length = data instanceof byte[] ? ((dataBytes = (byte[])data) == null ? 0 : dataBytes.length) : 0;
    }

    public TaskResult(boolean success, String message, List<Object> dataArray, int length) {
        this.success = success;
        this.message = message;
        this.data = null;
        this.dataList = Arrays.asList(dataArray.toArray());
        this.length = length;
    }

    public TaskResult(boolean success, String message, byte[] data, boolean profilingDone) {
        this.success = success;
        this.message = message;
        this.data = data;
        this.dataList = null;
        this.length = data == null ? 0 : data.length;
        this.profilingDone = profilingDone;
    }

    public String toString() {
        return String.format("TaskResult[success:%s, message:%s,datalength:%d]", this.success, this.message, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public boolean isDataArray() {
        return this.dataList != null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public List<Object> getDataArray() {
        return this.dataList;
    }

    public boolean isProfilingDone() {
        return this.profilingDone;
    }
}

