/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.task.spi.Executor;
import com.netflix.hystrix.HystrixCommand;
import java.util.Collections;
import java.util.List;
import org.trpr.platform.core.spi.event.EndpointEventProducer;
import org.trpr.platform.model.event.PlatformEvent;

public class ServiceProxyEventProducer {
    private static final String EVENT_PUBLISHING_URI = "evt://com.flipkart.phantom.events.";
    private EndpointEventProducer eventProducer;

    public void publishEvent(Executor executor, String commandName, Class eventSource, String eventType) {
        List executionEvents = Collections.EMPTY_LIST;
        Exception exception = null;
        if (executor != null) {
            HystrixCommand command = (HystrixCommand)executor;
            if (!eventType.startsWith("ASYNC") && !command.isExecutionComplete()) {
                return;
            }
            executionEvents = command.getExecutionEvents();
            exception = (Exception)command.getFailedExecutionException();
        }
        ServiceProxyEvent event = new ServiceProxyEvent(commandName, eventSource.getName(), eventType, executionEvents, exception);
        String endpointURI = EVENT_PUBLISHING_URI + eventType;
        this.eventProducer.publishEvent((PlatformEvent)event, endpointURI);
    }

    public void setEventProducer(EndpointEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

