/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event.consumer;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.netflix.hystrix.HystrixEventType;
import java.text.SimpleDateFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trpr.platform.core.impl.event.AbstractEndpointEventConsumerImpl;
import org.trpr.platform.model.event.PlatformEvent;

public class RequestLogger
extends AbstractEndpointEventConsumerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestLogger.class);
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy_HH:mm:ss");

    protected void handlePlatformEvent(PlatformEvent platformEvent) {
        if (platformEvent instanceof ServiceProxyEvent) {
            this.log((ServiceProxyEvent)platformEvent);
        } else {
            LOGGER.warn("Event Not Logged:Non compatible event received. Expecting ServiceProxyEvent Type but received " + platformEvent.getClass());
        }
    }

    private void log(ServiceProxyEvent event) {
        List<HystrixEventType> events = event.getHystrixEventList();
        if (events.size() > 1 || !events.contains(HystrixEventType.SUCCESS)) {
            LOGGER.error("ClientRequestId=" + event.getRequestId() + " " + "Command=" + event.getCommandName() + " " + (events.size() > 0 ? "Events=" + RequestLogger.eventsToString(events) + " " : "") + "TimeStamp=" + dateFormatter.format(event.getCreatedDate().getTime()) + " " + "EventType=" + event.getEventType() + " " + "EventSource=" + event.getEventSource() + " " + "TimeTaken=" + event.getExecutionTime(), (Throwable)event.getException());
        }
    }

    private static String eventsToString(List<HystrixEventType> events) {
        String joined = "";
        boolean first = true;
        for (HystrixEventType event : events) {
            if (first) {
                first = false;
            } else {
                joined = String.valueOf(joined) + ",";
            }
            joined = String.valueOf(joined) + event.name();
        }
        return joined;
    }
}

