/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.impl.TaskHandlerExecutor;
import com.flipkart.phantom.task.impl.TaskRequestWrapper;
import com.flipkart.phantom.task.impl.TaskResult;
import com.flipkart.phantom.task.impl.registry.TaskHandlerRegistry;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.netflix.hystrix.HystrixCommandProperties;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHandlerExecutorRepository
implements ExecutorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHandlerExecutorRepository.class);
    public static final String ONLY_ALPHANUMERIC_REGEX = "[^\\dA-Za-z_]";
    public static final String WHITESPACE_REGEX = "\\s+";
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private TaskHandlerRegistry registry;
    private TaskContext taskContext;

    @Override
    public Executor getExecutor(String commandName, String proxyName, RequestWrapper requestWrapper) {
        TaskHandler taskHandler;
        String refinedCommandName = commandName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        String refinedProxyName = proxyName.replaceAll(ONLY_ALPHANUMERIC_REGEX, "").replaceAll(WHITESPACE_REGEX, "");
        if (!commandName.equals(refinedCommandName)) {
            LOGGER.debug("Command names are not allowed to have Special characters/ whitespaces. Replacing: " + commandName + " with " + refinedCommandName);
        }
        if (!proxyName.equals(refinedProxyName)) {
            LOGGER.debug("Thread pool names are not allowed to have Special characters/ whitespaces. Replacing: " + proxyName + " with " + refinedProxyName);
        }
        if (proxyName.isEmpty()) {
            proxyName = commandName;
            LOGGER.debug("null/empty threadPoolName passed. defaulting to commandName: " + commandName);
        }
        if ((taskHandler = this.getTaskHandlerRegistry().getTaskHandlerByCommand(commandName)) != null) {
            if (!taskHandler.isActive()) {
                LOGGER.error("TaskHandler: " + taskHandler.getName() + " is not yet active. Command: " + commandName + " will not be processed");
                return null;
            }
            if (taskHandler instanceof HystrixTaskHandler) {
                HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
                LOGGER.debug("Isolation strategy: " + hystrixTaskHandler.getIsolationStrategy() + " for " + hystrixTaskHandler);
                if (hystrixTaskHandler.getIsolationStrategy() == HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE) {
                    return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, (TaskRequestWrapper)requestWrapper);
                }
                if (this.getTaskHandlerRegistry().getPoolSize(proxyName) == null) {
                    LOGGER.debug("Did not find a predefined pool size for " + proxyName + ". Falling back to default value of " + 10);
                    return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, hystrixTaskHandler.getExecutorTimeout(commandName), refinedProxyName, 10, (TaskRequestWrapper)requestWrapper);
                }
                return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, hystrixTaskHandler.getExecutorTimeout(commandName), refinedProxyName, this.getTaskHandlerRegistry().getPoolSize(proxyName), (TaskRequestWrapper)requestWrapper);
            }
            return new TaskHandlerExecutor(taskHandler, this.getTaskContext(), refinedCommandName, 10000, refinedProxyName, 10, (TaskRequestWrapper)requestWrapper);
        }
        throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
    }

    public Executor getExecutor(String commandName, RequestWrapper requestWrapper) {
        return this.getExecutor(commandName, commandName, requestWrapper);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, String proxyName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        return command.queue();
    }

    public TaskResult executeCommand(String commandName, String proxyName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        TaskHandlerExecutor command = (TaskHandlerExecutor)this.getExecutor(commandName, proxyName, requestWrapper);
        if (command == null) {
            throw new UnsupportedOperationException("Invoked unsupported command : " + commandName);
        }
        TaskRequestWrapper taskRequestWrapper = (TaskRequestWrapper)requestWrapper;
        try {
            return (TaskResult)command.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing command " + commandName + ": " + e.getMessage(), e);
        }
    }

    public TaskResult executeCommand(String commandName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeCommand(commandName, commandName, requestWrapper);
    }

    public Future<TaskResult> executeAsyncCommand(String commandName, RequestWrapper requestWrapper) throws UnsupportedOperationException {
        return this.executeAsyncCommand(commandName, commandName, requestWrapper);
    }

    @Override
    public AbstractHandlerRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(AbstractHandlerRegistry taskHandlerRegistry) {
        this.registry = (TaskHandlerRegistry)taskHandlerRegistry;
    }

    @Override
    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public TaskHandlerRegistry getTaskHandlerRegistry() {
        AbstractHandlerRegistry registry = this.getRegistry();
        if (registry instanceof TaskHandlerRegistry) {
            return (TaskHandlerRegistry)registry;
        }
        return new TaskHandlerRegistry();
    }
}

