/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event;

import com.netflix.hystrix.HystrixEventType;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.trpr.platform.model.event.PlatformEvent;

public class ServiceProxyEvent
extends PlatformEvent {
    private final List<HystrixEventType> hystrixEventList;
    private final Exception exception;
    private final String commandName;
    private final int executionTime;
    private final String requestId;

    private ServiceProxyEvent(Builder builder) {
        this.eventSource = builder.eventSource;
        this.eventType = builder.eventType;
        this.requestId = builder.requestId;
        this.hystrixEventList = builder.hystrixEventList;
        this.commandName = builder.commandName;
        this.exception = builder.exception;
        this.executionTime = builder.executionTime;
        this.eventStatus = this.exception == null ? EventStatus.SUCCESS.name() : EventStatus.FAILURE.name();
        this.eventMessage = this.exception == null ? EventStatus.SUCCESS.name() : this.exception.getMessage();
        this.setCreatedDate(Calendar.getInstance());
    }

    public Exception getException() {
        return this.exception;
    }

    public List<HystrixEventType> getHystrixEventList() {
        return this.hystrixEventList;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public int getExecutionTime() {
        return this.executionTime;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public static class Builder {
        private final String commandName;
        private final String eventType;
        private String requestId = null;
        private int executionTime = -1;
        private Exception exception = null;
        private String eventSource = "unspecified";
        private List<HystrixEventType> hystrixEventList = Collections.EMPTY_LIST;

        public Builder(String commandName, String eventType) {
            this.commandName = commandName;
            this.eventType = eventType;
        }

        public Builder withEventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public Builder withEventList(List<HystrixEventType> hystrixEventList) {
            this.hystrixEventList = hystrixEventList;
            return this;
        }

        public Builder withException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public Builder withExecutionTime(int executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public ServiceProxyEvent build() {
            return new ServiceProxyEvent(this);
        }
    }

    static enum EventStatus {
        SUCCESS,
        FAILURE;

    }
}

