/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.event;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.task.spi.Executor;
import com.netflix.hystrix.HystrixCommand;
import org.trpr.platform.core.spi.event.EndpointEventProducer;
import org.trpr.platform.model.event.PlatformEvent;

public class ServiceProxyEventProducer {
    private static final String EVENT_PUBLISHING_URI = "evt://com.flipkart.phantom.events.";
    private EndpointEventProducer eventProducer;

    public void publishEvent(Executor executor, String commandName, Class eventSource, String eventType, String requestID) {
        ServiceProxyEvent.Builder eventBuilder = new ServiceProxyEvent.Builder(commandName, eventType);
        eventBuilder.withEventSource(eventSource.getName()).withRequestId(requestID);
        if (executor != null) {
            HystrixCommand command = (HystrixCommand)executor;
            if (!eventType.startsWith("ASYNC") && !command.isExecutionComplete()) {
                return;
            }
            eventBuilder.withEventList(command.getExecutionEvents()).withExecutionTime(command.getExecutionTimeInMilliseconds()).withException((Exception)command.getFailedExecutionException());
        }
        String endpointURI = EVENT_PUBLISHING_URI + eventType;
        this.eventProducer.publishEvent((PlatformEvent)eventBuilder.build(), endpointURI);
    }

    public void publishEvent(Executor executor, String commandName, Class eventSource, String eventType) {
        this.publishEvent(executor, commandName, eventSource, eventType, null);
    }

    public void setEventProducer(EndpointEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

