/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.impl.registry;

import com.flipkart.phantom.task.impl.HystrixTaskHandler;
import com.flipkart.phantom.task.impl.TaskHandler;
import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.AbstractHandlerRegistry;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class TaskHandlerRegistry
implements AbstractHandlerRegistry {
    private static final Logger LOGGER = LogFactory.getLogger(TaskHandlerRegistry.class);
    private Map<String, TaskHandler> taskHandlers = new HashMap<String, TaskHandler>();
    private Map<String, TaskHandler> commandToTaskHandler = new ConcurrentHashMap<String, TaskHandler>();
    private Map<String, Integer> poolToThreadPoolSize = new ConcurrentHashMap<String, Integer>();

    @Override
    public AbstractHandlerRegistry.InitedHandlerInfo[] init(List<HandlerConfigInfo> handlerConfigInfoList, TaskContext taskContext) throws Exception {
        LinkedList<AbstractHandlerRegistry.InitedHandlerInfo> initedHanlderInfos = new LinkedList<AbstractHandlerRegistry.InitedHandlerInfo>();
        for (HandlerConfigInfo handlerConfigInfo : handlerConfigInfoList) {
            String[] taskHandlerBeanIds;
            String[] stringArray = taskHandlerBeanIds = handlerConfigInfo.getProxyHandlerContext().getBeanNamesForType(TaskHandler.class);
            int n = taskHandlerBeanIds.length;
            int n2 = 0;
            while (n2 < n) {
                String taskHandlerBeanId = stringArray[n2];
                TaskHandler taskHandler = (TaskHandler)handlerConfigInfo.getProxyHandlerContext().getBean(taskHandlerBeanId);
                try {
                    LOGGER.info("Initializing TaskHandler: " + taskHandler.getName());
                    taskHandler.init(taskContext);
                    taskHandler.activate();
                    initedHanlderInfos.add(new AbstractHandlerRegistry.InitedHandlerInfo(taskHandler, handlerConfigInfo));
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing TaskHandler {}. Error is: " + e.getMessage(), (Object)taskHandler.getName(), (Object)e);
                    throw new PlatformException("Error initializing TaskHandler: " + taskHandler.getName(), (Throwable)e);
                }
                this.registerTaskHandler(taskHandler);
                ++n2;
            }
        }
        return initedHanlderInfos.toArray(new AbstractHandlerRegistry.InitedHandlerInfo[0]);
    }

    @Override
    public void reinitHandler(String name, TaskContext taskContext) throws Exception {
        TaskHandler handler = this.taskHandlers.get(name);
        if (handler != null) {
            try {
                handler.deactivate();
                handler.shutdown(taskContext);
                handler.init(taskContext);
                handler.activate();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing TaskHandler {}. Error is: " + e.getMessage(), (Object)name, (Object)e);
                throw new PlatformException("Error reinitialising TaskHandler: " + name, (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown(TaskContext taskContext) throws Exception {
        for (String name : this.taskHandlers.keySet()) {
            LOGGER.info("Shutting down task handler: " + name);
            try {
                this.taskHandlers.get(name).shutdown(taskContext);
                this.taskHandlers.get(name).deactivate();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown task handler: " + name, (Throwable)e);
            }
        }
    }

    @Override
    public List<AbstractHandler> getHandlers() {
        return new ArrayList<AbstractHandler>(this.taskHandlers.values());
    }

    @Override
    public AbstractHandler getHandler(String name) {
        return this.taskHandlers.get(name);
    }

    public void registerTaskHandler(TaskHandler taskHandler) {
        this.taskHandlers.put(taskHandler.getName(), taskHandler);
        String[] stringArray = taskHandler.getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String commandName = stringArray[n2];
            LOGGER.info("Registering task handler " + taskHandler.getName() + " with command " + commandName);
            if (!this.commandToTaskHandler.containsValue(taskHandler)) {
                this.initializeThreadPoolMap(taskHandler);
            }
            if (this.commandToTaskHandler.get(commandName) != null) {
                throw new IllegalArgumentException("Command " + commandName + " is already registered with handler " + this.commandToTaskHandler.get(commandName).getName());
            }
            this.commandToTaskHandler.put(commandName, taskHandler);
            ++n2;
        }
    }

    private void initializeThreadPoolMap(TaskHandler taskHandler) {
        if (taskHandler instanceof HystrixTaskHandler) {
            HystrixTaskHandler hystrixTaskHandler = (HystrixTaskHandler)taskHandler;
            Map<String, Integer> threadParams = hystrixTaskHandler.getThreadPoolSizeParams();
            for (String threadParam : threadParams.keySet()) {
                this.poolToThreadPoolSize.put(threadParam, threadParams.get(threadParam));
            }
            Map<String, Integer> commandParams = hystrixTaskHandler.getCommandPoolSizeParams();
            for (String commandParam : commandParams.keySet()) {
                this.poolToThreadPoolSize.put(commandParam, commandParams.get(commandParam));
            }
        }
    }

    @Override
    public void unregisterTaskHandler(AbstractHandler taskHandler) {
        String[] stringArray = ((TaskHandler)taskHandler).getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String commandName = stringArray[n2];
            this.commandToTaskHandler.remove(commandName);
            ++n2;
        }
    }

    public TaskHandler getTaskHandlerByCommand(String commandString) {
        return this.commandToTaskHandler.get(commandString);
    }

    public Integer getPoolSize(String poolOrCommandName) {
        return this.poolToThreadPoolSize.get(poolOrCommandName);
    }
}

