/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.task.spi.registry;

import com.flipkart.phantom.task.spi.AbstractHandler;
import com.flipkart.phantom.task.spi.TaskContext;
import com.flipkart.phantom.task.spi.registry.HandlerConfigInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class AbstractHandlerRegistry<T extends AbstractHandler> {
    private static final Logger LOGGER = LogFactory.getLogger(AbstractHandlerRegistry.class);
    private static final int DEFAULT_HANDLER_INIT_CONCURRENCY = 5;
    private int handlerInitConcurrency = 5;
    protected Map<String, T> handlers = new HashMap<String, T>();

    public InitedHandlerInfo<T>[] init(List<HandlerConfigInfo> handlerConfigInfoList, TaskContext taskContext) throws Exception {
        LinkedList<InitedHandlerInfo<AbstractHandler>> initedHandlerInfos = new LinkedList<InitedHandlerInfo<AbstractHandler>>();
        for (HandlerConfigInfo handlerConfigInfo : handlerConfigInfoList) {
            String[] handlerBeanIds;
            for (String taskHandlerBeanId : handlerBeanIds = handlerConfigInfo.getProxyHandlerContext().getBeanNamesForType(this.getHandlerType())) {
                AbstractHandler handler = (AbstractHandler)handlerConfigInfo.getProxyHandlerContext().getBean(taskHandlerBeanId);
                try {
                    if (handler.isActive()) continue;
                    LOGGER.info("Initializing {} : " + handler.getName(), (Object)this.getHandlerType().getName());
                    handler.init(taskContext);
                    this.postInitHandler(handler);
                    handler.activate();
                    initedHandlerInfos.add(new InitedHandlerInfo<AbstractHandler>(handler, handlerConfigInfo));
                    this.handlers.put(handler.getName(), handler);
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing " + this.getHandlerType().getName() + " : {}. Error is: " + e.getMessage(), (Object)handler.getName(), (Object)e);
                    if (handler.getInitOutcomeStatus() == 999999) {
                        throw new PlatformException("Error initializing vetoing handler " + this.getHandlerType().getName() + " : " + handler.getName());
                    }
                    LOGGER.warn("Continuing after init failed for non-vetoing handler " + this.getHandlerType().getName() + " : " + handler.getName());
                }
            }
        }
        return initedHandlerInfos.toArray(new InitedHandlerInfo[0]);
    }

    public void reinitHandler(String name, TaskContext taskContext) throws Exception {
        AbstractHandler handler = (AbstractHandler)this.handlers.get(name);
        if (handler != null) {
            try {
                handler.deactivate();
                handler.shutdown(taskContext);
                handler.init(taskContext);
                handler.activate();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing " + this.getHandlerType().getName() + " : {}. Error is: " + e.getMessage(), (Object)handler.getName(), (Object)e);
                throw new PlatformException("Error reinitialising " + this.getHandlerType().getName() + " : " + handler.getName(), (Throwable)e);
            }
        }
    }

    public void shutdown(TaskContext taskContext) throws Exception {
        for (String name : this.handlers.keySet()) {
            LOGGER.info("Shutting down {}: " + name, (Object)this.getHandlerType().getName());
            try {
                ((AbstractHandler)this.handlers.get(name)).shutdown(taskContext);
                ((AbstractHandler)this.handlers.get(name)).deactivate();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown {}: " + name, (Object)this.getHandlerType().getName(), (Object)e);
            }
        }
    }

    public List<T> getHandlers() {
        return new ArrayList<T>(this.handlers.values());
    }

    public T getHandler(String name) {
        return (T)((AbstractHandler)this.handlers.get(name));
    }

    public void unregisterTaskHandler(T handler) {
        this.handlers.remove(((AbstractHandler)handler).getName());
        this.postUnregisterHandler(handler);
    }

    protected abstract Class<T> getHandlerType();

    protected void postInitHandler(T handler) {
    }

    protected void postUnregisterHandler(T handler) {
    }

    public int getHandlerInitConcurrency() {
        return this.handlerInitConcurrency;
    }

    public void setHandlerInitConcurrency(int handlerInitConcurrency) {
        this.handlerInitConcurrency = handlerInitConcurrency;
    }

    public static final class InitedHandlerInfo<T extends AbstractHandler> {
        private T initedHandler;
        private HandlerConfigInfo handlerConfigInfo;

        public InitedHandlerInfo(T initedHandler, HandlerConfigInfo handlerConfigInfo) {
            this.initedHandler = initedHandler;
            this.handlerConfigInfo = handlerConfigInfo;
        }

        public T getInitedHandler() {
            return this.initedHandler;
        }

        public HandlerConfigInfo getHandlerConfigInfo() {
            return this.handlerConfigInfo;
        }
    }
}

